/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Week;

public class WeekTests
extends TestCase {
    private Week w1Y1900;
    private Week w2Y1900;
    private Week w51Y9999;
    private Week w52Y9999;

    public static Test suite() {
        return new TestSuite(WeekTests.class);
    }

    public WeekTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.w1Y1900 = new Week(1, 1900);
        this.w2Y1900 = new Week(2, 1900);
        this.w51Y9999 = new Week(51, 9999);
        this.w52Y9999 = new Week(52, 9999);
    }

    public void testEquals() {
        Week week = new Week(1, 2002);
        Week week2 = new Week(1, 2002);
        WeekTests.assertTrue((boolean)week.equals(week2));
        WeekTests.assertTrue((boolean)week2.equals(week));
        week = new Week(2, 2002);
        WeekTests.assertFalse((boolean)week.equals(week2));
        week2 = new Week(2, 2002);
        WeekTests.assertTrue((boolean)week.equals(week2));
        week = new Week(2, 2003);
        WeekTests.assertFalse((boolean)week.equals(week2));
        week2 = new Week(2, 2003);
        WeekTests.assertTrue((boolean)week.equals(week2));
    }

    public void testW1Y1900Previous() {
        Week week = (Week)this.w1Y1900.previous();
        WeekTests.assertNull((Object)week);
    }

    public void testW1Y1900Next() {
        Week week = (Week)this.w1Y1900.next();
        WeekTests.assertEquals((Object)this.w2Y1900, (Object)week);
    }

    public void testW52Y9999Previous() {
        Week week = (Week)this.w52Y9999.previous();
        WeekTests.assertEquals((Object)this.w51Y9999, (Object)week);
    }

    public void testW52Y9999Next() {
        Week week = (Week)this.w52Y9999.next();
        WeekTests.assertNull((Object)week);
    }

    public void testSerialization() {
        Week week = new Week(24, 1999);
        Week week2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(week);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            week2 = (Week)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        WeekTests.assertEquals((Object)week, week2);
    }

    public void testHashcode() {
        Week week = new Week(2, 2003);
        Week week2 = new Week(2, 2003);
        WeekTests.assertTrue((boolean)week.equals(week2));
        int n = week.hashCode();
        int n2 = week2.hashCode();
        WeekTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Week week = new Week(1, 1999);
        WeekTests.assertFalse((boolean)(week instanceof Cloneable));
    }

    public void testWeek12005() {
        Week week = new Week(1, 2005);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        calendar.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104710400000L, (long)week.getFirstMillisecond(calendar));
        WeekTests.assertEquals((long)1105315199999L, (long)week.getLastMillisecond(calendar));
        Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        calendar2.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104706800000L, (long)week.getFirstMillisecond(calendar2));
        WeekTests.assertEquals((long)1105311599999L, (long)week.getLastMillisecond(calendar2));
        Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        WeekTests.assertEquals((long)1104037200000L, (long)week.getFirstMillisecond(calendar3));
        WeekTests.assertEquals((long)1104641999999L, (long)week.getLastMillisecond(calendar3));
    }

    public void testWeek532005() {
        Week week = new Week(53, 2004);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        calendar.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104105600000L, (long)week.getFirstMillisecond(calendar));
        WeekTests.assertEquals((long)1104710399999L, (long)week.getLastMillisecond(calendar));
        Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        calendar2.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104102000000L, (long)week.getFirstMillisecond(calendar2));
        WeekTests.assertEquals((long)1104706799999L, (long)week.getLastMillisecond(calendar2));
        week = new Week(53, 2005);
        Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        WeekTests.assertEquals((long)1135486800000L, (long)week.getFirstMillisecond(calendar3));
        WeekTests.assertEquals((long)1136091599999L, (long)week.getLastMillisecond(calendar3));
    }
}

