/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Year;

public class TimeTableXYDatasetTests
extends TestCase {
    private static final double DELTA = 1.0E-10;

    public static Test suite() {
        return new TestSuite(TimeTableXYDatasetTests.class);
    }

    public TimeTableXYDatasetTests(String string) {
        super(string);
    }

    public void testStandard() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        timeTableXYDataset.add(new Year(1999), 1.0, "Series 1");
        TimeTableXYDatasetTests.assertEquals((int)timeTableXYDataset.getItemCount(), (int)1);
        TimeTableXYDatasetTests.assertEquals((int)timeTableXYDataset.getSeriesCount(), (int)1);
        timeTableXYDataset.add(new Year(2000), 2.0, "Series 2");
        TimeTableXYDatasetTests.assertEquals((int)timeTableXYDataset.getItemCount(), (int)2);
        TimeTableXYDatasetTests.assertEquals((int)timeTableXYDataset.getSeriesCount(), (int)2);
        TimeTableXYDatasetTests.assertEquals((double)timeTableXYDataset.getYValue(0, 0), (double)1.0, (double)1.0E-10);
        TimeTableXYDatasetTests.assertTrue((boolean)Double.isNaN(timeTableXYDataset.getYValue(0, 1)));
        TimeTableXYDatasetTests.assertTrue((boolean)Double.isNaN(timeTableXYDataset.getYValue(1, 0)));
        TimeTableXYDatasetTests.assertEquals((double)timeTableXYDataset.getYValue(1, 1), (double)2.0, (double)1.0E-10);
    }

    public void testGetTimePeriod() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        timeTableXYDataset.add(new Year(1999), 1.0, "Series 1");
        timeTableXYDataset.add(new Year(1998), 2.0, "Series 1");
        timeTableXYDataset.add(new Year(1996), 3.0, "Series 1");
        TimeTableXYDatasetTests.assertEquals((Object)timeTableXYDataset.getTimePeriod(0), (Object)new Year(1996));
        TimeTableXYDatasetTests.assertEquals((Object)timeTableXYDataset.getTimePeriod(1), (Object)new Year(1998));
        TimeTableXYDatasetTests.assertEquals((Object)timeTableXYDataset.getTimePeriod(2), (Object)new Year(1999));
    }

    public void testEquals() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        TimeTableXYDataset timeTableXYDataset2 = new TimeTableXYDataset();
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset2.equals(timeTableXYDataset));
        timeTableXYDataset.add(new Year(1999), 123.4, "S1");
        TimeTableXYDatasetTests.assertFalse((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
        timeTableXYDataset2.add(new Year(1999), 123.4, "S1");
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
        timeTableXYDataset.setDomainIsPointsInTime(!timeTableXYDataset.getDomainIsPointsInTime());
        TimeTableXYDatasetTests.assertFalse((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
        timeTableXYDataset2.setDomainIsPointsInTime(!timeTableXYDataset2.getDomainIsPointsInTime());
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
        timeTableXYDataset = new TimeTableXYDataset(TimeZone.getTimeZone("GMT"));
        timeTableXYDataset2 = new TimeTableXYDataset(TimeZone.getTimeZone("America/Los_Angeles"));
        TimeTableXYDatasetTests.assertFalse((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
    }

    public void testClone() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        timeTableXYDataset.add(new Year(1999), 25.0, "Series");
        TimeTableXYDataset timeTableXYDataset2 = null;
        try {
            timeTableXYDataset2 = (TimeTableXYDataset)timeTableXYDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            TimeTableXYDatasetTests.assertTrue((boolean)false);
        }
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset2.equals(timeTableXYDataset));
        timeTableXYDataset2.add(new Year(2004), 1.2, "SS");
        TimeTableXYDatasetTests.assertFalse((boolean)timeTableXYDataset2.equals(timeTableXYDataset));
    }

    public void testSerialization() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        timeTableXYDataset.add(new Year(1999), 123.4, "S1");
        TimeTableXYDataset timeTableXYDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timeTableXYDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timeTableXYDataset2 = (TimeTableXYDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimeTableXYDatasetTests.assertTrue((boolean)timeTableXYDataset.equals(timeTableXYDataset2));
    }
}

