/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Year;

public class TimeSeriesTests
extends TestCase
implements SeriesChangeListener {
    private TimeSeries seriesA;
    private TimeSeries seriesB;
    private TimeSeries seriesC;
    private boolean gotSeriesChangeEvent = false;

    public static Test suite() {
        return new TestSuite(TimeSeriesTests.class);
    }

    public TimeSeriesTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.seriesA = new TimeSeries("Series A", Year.class);
        try {
            this.seriesA.add((RegularTimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((RegularTimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((RegularTimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((RegularTimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((RegularTimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((RegularTimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
        this.seriesB = new TimeSeries("Series B", Year.class);
        try {
            this.seriesB.add((RegularTimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((RegularTimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((RegularTimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
        this.seriesC = new TimeSeries("Series C", Year.class);
        try {
            this.seriesC.add((RegularTimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((RegularTimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((RegularTimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.gotSeriesChangeEvent = true;
    }

    public void testClone() {
        TimeSeries timeSeries = new TimeSeries("Test Series");
        Day day = new Day(1, 1, 2002);
        try {
            timeSeries.add((RegularTimePeriod)day, new Integer(42));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem adding to series.");
        }
        TimeSeries timeSeries2 = null;
        try {
            timeSeries2 = (TimeSeries)timeSeries.clone();
            timeSeries2.setKey((Comparable)((Object)"Clone Series"));
            try {
                timeSeries2.update(day, (Number)new Integer(10));
            }
            catch (SeriesException seriesException) {
                System.err.println("Problem updating series.");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            TimeSeriesTests.assertTrue((boolean)false);
        }
        int n = timeSeries.getValue(day).intValue();
        int n2 = timeSeries2.getValue(day).intValue();
        TimeSeriesTests.assertEquals((int)42, (int)n);
        TimeSeriesTests.assertEquals((int)10, (int)n2);
        TimeSeriesTests.assertEquals((Object)"Test Series", (Object)timeSeries.getKey());
        TimeSeriesTests.assertEquals((Object)"Clone Series", (Object)timeSeries2.getKey());
    }

    public void testAddValue() {
        try {
            this.seriesA.add((RegularTimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem adding to series.");
        }
        int n = this.seriesA.getValue(0).intValue();
        TimeSeriesTests.assertEquals((int)1, (int)n);
    }

    public void testGetValue() {
        Number number = this.seriesA.getValue(new Year(1999));
        TimeSeriesTests.assertNull((Object)number);
        int n = this.seriesA.getValue(new Year(2000)).intValue();
        TimeSeriesTests.assertEquals((int)102000, (int)n);
    }

    public void testDelete() {
        this.seriesA.delete(0, 0);
        TimeSeriesTests.assertEquals((int)5, (int)this.seriesA.getItemCount());
        Number number = this.seriesA.getValue(new Year(2000));
        TimeSeriesTests.assertNull((Object)number);
    }

    public void testDelete2() {
        TimeSeries timeSeries = new TimeSeries("Series", Year.class);
        timeSeries.add((RegularTimePeriod)new Year(2000), 13.75);
        timeSeries.add((RegularTimePeriod)new Year(2001), 11.9);
        timeSeries.add((RegularTimePeriod)new Year(2002), null);
        timeSeries.addChangeListener(this);
        this.gotSeriesChangeEvent = false;
        timeSeries.delete(new Year(2001));
        TimeSeriesTests.assertTrue((boolean)this.gotSeriesChangeEvent);
        TimeSeriesTests.assertEquals((int)2, (int)timeSeries.getItemCount());
        TimeSeriesTests.assertEquals(null, (Object)timeSeries.getValue(new Year(2001)));
    }

    public void testSerialization() {
        TimeSeries timeSeries = new TimeSeries("A test", Year.class);
        timeSeries.add((RegularTimePeriod)new Year(2000), 13.75);
        timeSeries.add((RegularTimePeriod)new Year(2001), 11.9);
        timeSeries.add((RegularTimePeriod)new Year(2002), null);
        timeSeries.add((RegularTimePeriod)new Year(2005), 19.32);
        timeSeries.add((RegularTimePeriod)new Year(2007), 16.89);
        TimeSeries timeSeries2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timeSeries);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timeSeries2 = (TimeSeries)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimeSeriesTests.assertTrue((boolean)timeSeries.equals(timeSeries2));
    }

    public void testEquals() {
        TimeSeries timeSeries = new TimeSeries("Time Series 1");
        TimeSeries timeSeries2 = new TimeSeries("Time Series 2");
        boolean bl = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertFalse((String)"b1", (boolean)bl);
        timeSeries2.setKey((Comparable)((Object)"Time Series 1"));
        boolean bl2 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertTrue((String)"b2", (boolean)bl2);
        Day day = new Day();
        RegularTimePeriod regularTimePeriod = ((RegularTimePeriod)day).next();
        timeSeries.add((RegularTimePeriod)day, 100.0);
        timeSeries.add(regularTimePeriod, 200.0);
        boolean bl3 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertFalse((String)"b3", (boolean)bl3);
        timeSeries2.add((RegularTimePeriod)day, 100.0);
        timeSeries2.add(regularTimePeriod, 200.0);
        boolean bl4 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertTrue((String)"b4", (boolean)bl4);
        timeSeries.setMaximumItemCount(100);
        boolean bl5 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertFalse((String)"b5", (boolean)bl5);
        timeSeries2.setMaximumItemCount(100);
        boolean bl6 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertTrue((String)"b6", (boolean)bl6);
        timeSeries.setHistoryCount(100);
        boolean bl7 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertFalse((String)"b7", (boolean)bl7);
        timeSeries2.setHistoryCount(100);
        boolean bl8 = timeSeries.equals(timeSeries2);
        TimeSeriesTests.assertTrue((String)"b8", (boolean)bl8);
    }

    public void testEquals2() {
        TimeSeries timeSeries = new TimeSeries("Series", null, null, Day.class);
        TimeSeries timeSeries2 = new TimeSeries("Series", null, null, Day.class);
        TimeSeriesTests.assertTrue((boolean)timeSeries.equals(timeSeries2));
    }

    public void testCreateCopy1() {
        TimeSeries timeSeries = new TimeSeries("Series", Month.class);
        timeSeries.add((RegularTimePeriod)new Month(1, 2003), 45.0);
        timeSeries.add((RegularTimePeriod)new Month(2, 2003), 55.0);
        timeSeries.add((RegularTimePeriod)new Month(6, 2003), 35.0);
        timeSeries.add((RegularTimePeriod)new Month(11, 2003), 85.0);
        timeSeries.add((RegularTimePeriod)new Month(12, 2003), 75.0);
        try {
            TimeSeries timeSeries2 = timeSeries.createCopy(new Month(11, 2002), new Month(12, 2002));
            TimeSeriesTests.assertEquals((int)0, (int)timeSeries2.getItemCount());
            TimeSeries timeSeries3 = timeSeries.createCopy(new Month(11, 2002), new Month(1, 2003));
            TimeSeriesTests.assertEquals((int)1, (int)timeSeries3.getItemCount());
            TimeSeries timeSeries4 = timeSeries.createCopy(new Month(11, 2002), new Month(4, 2003));
            TimeSeriesTests.assertEquals((int)2, (int)timeSeries4.getItemCount());
            TimeSeries timeSeries5 = timeSeries.createCopy(new Month(11, 2002), new Month(12, 2003));
            TimeSeriesTests.assertEquals((int)5, (int)timeSeries5.getItemCount());
            TimeSeries timeSeries6 = timeSeries.createCopy(new Month(11, 2002), new Month(3, 2004));
            TimeSeriesTests.assertEquals((int)5, (int)timeSeries6.getItemCount());
            TimeSeries timeSeries7 = timeSeries.createCopy(new Month(1, 2003), new Month(1, 2003));
            TimeSeriesTests.assertEquals((int)1, (int)timeSeries7.getItemCount());
            TimeSeries timeSeries8 = timeSeries.createCopy(new Month(1, 2003), new Month(4, 2003));
            TimeSeriesTests.assertEquals((int)2, (int)timeSeries8.getItemCount());
            TimeSeries timeSeries9 = timeSeries.createCopy(new Month(1, 2003), new Month(12, 2003));
            TimeSeriesTests.assertEquals((int)5, (int)timeSeries9.getItemCount());
            TimeSeries timeSeries10 = timeSeries.createCopy(new Month(1, 2003), new Month(3, 2004));
            TimeSeriesTests.assertEquals((int)5, (int)timeSeries10.getItemCount());
            TimeSeries timeSeries11 = timeSeries.createCopy(new Month(5, 2003), new Month(12, 2003));
            TimeSeriesTests.assertEquals((int)3, (int)timeSeries11.getItemCount());
            TimeSeries timeSeries12 = timeSeries.createCopy(new Month(5, 2003), new Month(3, 2004));
            TimeSeriesTests.assertEquals((int)3, (int)timeSeries12.getItemCount());
            TimeSeries timeSeries13 = timeSeries.createCopy(new Month(12, 2003), new Month(12, 2003));
            TimeSeriesTests.assertEquals((int)1, (int)timeSeries13.getItemCount());
            TimeSeries timeSeries14 = timeSeries.createCopy(new Month(12, 2003), new Month(3, 2004));
            TimeSeriesTests.assertEquals((int)1, (int)timeSeries14.getItemCount());
            TimeSeries timeSeries15 = timeSeries.createCopy(new Month(1, 2004), new Month(3, 2004));
            TimeSeriesTests.assertEquals((int)0, (int)timeSeries15.getItemCount());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            TimeSeriesTests.assertTrue((boolean)false);
        }
    }

    public void testSetMaximumItemCount() {
        TimeSeries timeSeries = new TimeSeries("S1", Year.class);
        timeSeries.add((RegularTimePeriod)new Year(2000), 13.75);
        timeSeries.add((RegularTimePeriod)new Year(2001), 11.9);
        timeSeries.add((RegularTimePeriod)new Year(2002), null);
        timeSeries.add((RegularTimePeriod)new Year(2005), 19.32);
        timeSeries.add((RegularTimePeriod)new Year(2007), 16.89);
        TimeSeriesTests.assertTrue((timeSeries.getItemCount() == 5 ? 1 : 0) != 0);
        timeSeries.setMaximumItemCount(3);
        TimeSeriesTests.assertTrue((timeSeries.getItemCount() == 3 ? 1 : 0) != 0);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(0);
        TimeSeriesTests.assertTrue((boolean)timeSeriesDataItem.getPeriod().equals(new Year(2002)));
    }

    public void testAddOrUpdate() {
        TimeSeries timeSeries = new TimeSeries("S1", Year.class);
        timeSeries.setMaximumItemCount(2);
        timeSeries.addOrUpdate((RegularTimePeriod)new Year(2000), 100.0);
        TimeSeriesTests.assertEquals((int)1, (int)timeSeries.getItemCount());
        timeSeries.addOrUpdate((RegularTimePeriod)new Year(2001), 101.0);
        TimeSeriesTests.assertEquals((int)2, (int)timeSeries.getItemCount());
        timeSeries.addOrUpdate((RegularTimePeriod)new Year(2001), 102.0);
        TimeSeriesTests.assertEquals((int)2, (int)timeSeries.getItemCount());
        timeSeries.addOrUpdate((RegularTimePeriod)new Year(2002), 103.0);
        TimeSeriesTests.assertEquals((int)2, (int)timeSeries.getItemCount());
    }

    public void testBug1075255() {
        TimeSeries timeSeries = new TimeSeries("dummy", FixedMillisecond.class);
        timeSeries.add((RegularTimePeriod)new FixedMillisecond(0L), 0.0);
        TimeSeries timeSeries2 = new TimeSeries("dummy2", FixedMillisecond.class);
        timeSeries2.add((RegularTimePeriod)new FixedMillisecond(0L), 1.0);
        try {
            timeSeries.addAndOrUpdate(timeSeries2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TimeSeriesTests.assertTrue((boolean)false);
        }
        TimeSeriesTests.assertEquals((int)1, (int)timeSeries.getItemCount());
    }
}

