/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesDataItemTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimeSeriesDataItemTests.class);
    }

    public TimeSeriesDataItemTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItemTests.assertTrue((boolean)timeSeriesDataItem.equals(timeSeriesDataItem));
    }

    public void testEquals() {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItem timeSeriesDataItem2 = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItemTests.assertTrue((boolean)timeSeriesDataItem.equals(timeSeriesDataItem2));
        TimeSeriesDataItemTests.assertTrue((boolean)timeSeriesDataItem2.equals(timeSeriesDataItem));
        timeSeriesDataItem.setValue(new Integer(5));
        TimeSeriesDataItemTests.assertFalse((boolean)timeSeriesDataItem.equals(timeSeriesDataItem2));
        timeSeriesDataItem2.setValue(new Integer(5));
        TimeSeriesDataItemTests.assertTrue((boolean)timeSeriesDataItem.equals(timeSeriesDataItem2));
    }

    public void testSerialization() {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItem timeSeriesDataItem2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timeSeriesDataItem);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timeSeriesDataItem2 = (TimeSeriesDataItem)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimeSeriesDataItemTests.assertEquals((Object)timeSeriesDataItem, timeSeriesDataItem2);
    }
}

