/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.Year;

public class TimePeriodValuesTests
extends TestCase {
    private TimePeriodValues seriesA;
    private TimePeriodValues seriesB;
    private TimePeriodValues seriesC;

    public static Test suite() {
        return new TestSuite(TimePeriodValuesTests.class);
    }

    public TimePeriodValuesTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.seriesA = new TimePeriodValues("Series A");
        try {
            this.seriesA.add((TimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((TimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((TimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((TimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((TimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((TimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
        this.seriesB = new TimePeriodValues("Series B");
        try {
            this.seriesB.add((TimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((TimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((TimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
        this.seriesC = new TimePeriodValues("Series C");
        try {
            this.seriesC.add((TimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((TimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((TimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem creating series.");
        }
    }

    public void testClone() {
        TimePeriodValues timePeriodValues = new TimePeriodValues("Test Series");
        Day day = new Day(1, 1, 2002);
        try {
            timePeriodValues.add((TimePeriod)day, new Integer(42));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem adding to collection.");
        }
        TimePeriodValues timePeriodValues2 = null;
        try {
            timePeriodValues2 = (TimePeriodValues)timePeriodValues.clone();
            timePeriodValues2.setKey((Comparable)((Object)"Clone Series"));
            try {
                timePeriodValues2.update(0, new Integer(10));
            }
            catch (SeriesException seriesException) {
                System.err.println("Problem updating series.");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            TimePeriodValuesTests.assertTrue((boolean)false);
        }
        int n = timePeriodValues.getValue(0).intValue();
        int n2 = timePeriodValues2.getValue(0).intValue();
        TimePeriodValuesTests.assertEquals((int)42, (int)n);
        TimePeriodValuesTests.assertEquals((int)10, (int)n2);
        TimePeriodValuesTests.assertEquals((Object)"Test Series", (Object)timePeriodValues.getKey());
        TimePeriodValuesTests.assertEquals((Object)"Clone Series", (Object)timePeriodValues2.getKey());
    }

    public void testAddValue() {
        TimePeriodValues timePeriodValues = new TimePeriodValues("Test");
        try {
            timePeriodValues.add((TimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException seriesException) {
            System.err.println("Problem adding to series.");
        }
        int n = timePeriodValues.getValue(0).intValue();
        TimePeriodValuesTests.assertEquals((int)1, (int)n);
    }

    public void testSerialization() {
        TimePeriodValues timePeriodValues = new TimePeriodValues("A test");
        timePeriodValues.add((TimePeriod)new Year(2000), 13.75);
        timePeriodValues.add((TimePeriod)new Year(2001), 11.9);
        timePeriodValues.add((TimePeriod)new Year(2002), null);
        timePeriodValues.add((TimePeriod)new Year(2005), 19.32);
        timePeriodValues.add((TimePeriod)new Year(2007), 16.89);
        TimePeriodValues timePeriodValues2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(timePeriodValues);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            timePeriodValues2 = (TimePeriodValues)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TimePeriodValuesTests.assertTrue((boolean)timePeriodValues.equals(timePeriodValues2));
    }

    public void testEquals() {
        TimePeriodValues timePeriodValues = new TimePeriodValues("Time Series 1");
        TimePeriodValues timePeriodValues2 = new TimePeriodValues("Time Series 2");
        boolean bl = timePeriodValues.equals(timePeriodValues2);
        TimePeriodValuesTests.assertFalse((String)"b1", (boolean)bl);
        timePeriodValues2.setKey((Comparable)((Object)"Time Series 1"));
        boolean bl2 = timePeriodValues.equals(timePeriodValues2);
        TimePeriodValuesTests.assertTrue((String)"b2", (boolean)bl2);
        Day day = new Day();
        RegularTimePeriod regularTimePeriod = ((RegularTimePeriod)day).next();
        timePeriodValues.add((TimePeriod)day, 100.0);
        timePeriodValues.add((TimePeriod)regularTimePeriod, 200.0);
        boolean bl3 = timePeriodValues.equals(timePeriodValues2);
        TimePeriodValuesTests.assertFalse((String)"b3", (boolean)bl3);
        timePeriodValues2.add((TimePeriod)day, 100.0);
        timePeriodValues2.add((TimePeriod)regularTimePeriod, 200.0);
        boolean bl4 = timePeriodValues.equals(timePeriodValues2);
        TimePeriodValuesTests.assertTrue((String)"b4", (boolean)bl4);
    }

    public void test1161329() {
        TimePeriodValues timePeriodValues = new TimePeriodValues("Test");
        RegularTimePeriod regularTimePeriod = new Day();
        timePeriodValues.add((TimePeriod)regularTimePeriod, 1.0);
        regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
        timePeriodValues.add((TimePeriod)regularTimePeriod, 2.0);
        timePeriodValues.delete(0, 1);
        TimePeriodValuesTests.assertEquals((int)0, (int)timePeriodValues.getItemCount());
        timePeriodValues.add((TimePeriod)regularTimePeriod, 2.0);
        TimePeriodValuesTests.assertEquals((int)1, (int)timePeriodValues.getItemCount());
    }
}

