/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.SimpleTimePeriod;

public class SimpleTimePeriodTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleTimePeriodTests.class);
    }

    public SimpleTimePeriodTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(1000L), new Date(1001L));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod.equals(simpleTimePeriod));
    }

    public void testEquals() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(1000L), new Date(1004L));
        SimpleTimePeriod simpleTimePeriod2 = new SimpleTimePeriod(new Date(1000L), new Date(1004L));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod2.equals(simpleTimePeriod));
        simpleTimePeriod = new SimpleTimePeriod(new Date(1002L), new Date(1004L));
        SimpleTimePeriodTests.assertFalse((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(1002L), new Date(1004L));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(1002L), new Date(1003L));
        SimpleTimePeriodTests.assertFalse((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(1002L), new Date(1003L));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
    }

    public void testSerialization() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(1000L), new Date(1001L));
        SimpleTimePeriod simpleTimePeriod2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(simpleTimePeriod);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            simpleTimePeriod2 = (SimpleTimePeriod)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SimpleTimePeriodTests.assertEquals((Object)simpleTimePeriod, simpleTimePeriod2);
    }

    public void testHashcode() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriod simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertTrue((boolean)simpleTimePeriod.equals(simpleTimePeriod2));
        int n = simpleTimePeriod.hashCode();
        int n2 = simpleTimePeriod2.hashCode();
        SimpleTimePeriodTests.assertEquals((int)n, (int)n2);
    }

    public void testClone() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertFalse((boolean)(simpleTimePeriod instanceof Cloneable));
    }

    public void testCompareTo() {
        SimpleTimePeriod simpleTimePeriod = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriod simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)0, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(9L), new Date(21L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(11L), new Date(19L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(9L), new Date(19L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(11L), new Date(21L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(10L), new Date(18L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)-1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
        simpleTimePeriod = new SimpleTimePeriod(new Date(10L), new Date(22L));
        simpleTimePeriod2 = new SimpleTimePeriod(new Date(10L), new Date(20L));
        SimpleTimePeriodTests.assertEquals((int)1, (int)simpleTimePeriod.compareTo(simpleTimePeriod2));
    }
}

