/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Second;

public class SecondTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SecondTests.class);
    }

    public SecondTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Second second = new Second();
        SecondTests.assertTrue((boolean)second.equals(second));
    }

    public void testEquals() {
        Day day = new Day(29, 3, 2002);
        Hour hour = new Hour(15, day);
        Minute minute = new Minute(15, hour);
        Second second = new Second(34, minute);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        Second second2 = new Second(34, minute2);
        SecondTests.assertTrue((boolean)second.equals(second2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Second second = new Second(new Date(1016729758999L), timeZone);
        Second second2 = new Second(new Date(1016729759000L), timeZone);
        SecondTests.assertEquals((int)58, (int)second.getSecond());
        SecondTests.assertEquals((long)1016729758999L, (long)second.getLastMillisecond(timeZone));
        SecondTests.assertEquals((int)59, (int)second2.getSecond());
        SecondTests.assertEquals((long)1016729759000L, (long)second2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("America/Chicago");
        Second second = new Second(new Date(1016751358999L), timeZone);
        Second second2 = new Second(new Date(1016751359000L), timeZone);
        SecondTests.assertEquals((int)58, (int)second.getSecond());
        SecondTests.assertEquals((long)1016751358999L, (long)second.getLastMillisecond(timeZone));
        SecondTests.assertEquals((int)59, (int)second2.getSecond());
        SecondTests.assertEquals((long)1016751359000L, (long)second2.getFirstMillisecond(timeZone));
    }

    public void testSerialization() {
        Second second = new Second();
        Second second2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(second);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            second2 = (Second)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SecondTests.assertEquals((Object)second, second2);
    }

    public void testHashcode() {
        Second second = new Second(13, 45, 5, 1, 2, 2003);
        Second second2 = new Second(13, 45, 5, 1, 2, 2003);
        SecondTests.assertTrue((boolean)second.equals(second2));
        int n = second.hashCode();
        int n2 = second2.hashCode();
        SecondTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Second second = new Second(13, 45, 5, 1, 2, 2003);
        SecondTests.assertFalse((boolean)(second instanceof Cloneable));
    }
}

