/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;

public class MinuteTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MinuteTests.class);
    }

    public MinuteTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Minute minute = new Minute();
        MinuteTests.assertTrue((boolean)minute.equals(minute));
    }

    public void testEquals() {
        Day day = new Day(29, 3, 2002);
        Hour hour = new Hour(15, day);
        Minute minute = new Minute(15, hour);
        Day day2 = new Day(29, 3, 2002);
        Hour hour2 = new Hour(15, day2);
        Minute minute2 = new Minute(15, hour2);
        MinuteTests.assertTrue((boolean)minute.equals(minute2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Minute minute = new Minute(new Date(1016729699999L), timeZone);
        Minute minute2 = new Minute(new Date(1016729700000L), timeZone);
        MinuteTests.assertEquals((int)54, (int)minute.getMinute());
        MinuteTests.assertEquals((long)1016729699999L, (long)minute.getLastMillisecond(timeZone));
        MinuteTests.assertEquals((int)55, (int)minute2.getMinute());
        MinuteTests.assertEquals((long)1016729700000L, (long)minute2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Asia/Singapore");
        Minute minute = new Minute(new Date(1016700899999L), timeZone);
        Minute minute2 = new Minute(new Date(1016700900000L), timeZone);
        MinuteTests.assertEquals((int)54, (int)minute.getMinute());
        MinuteTests.assertEquals((long)1016700899999L, (long)minute.getLastMillisecond(timeZone));
        MinuteTests.assertEquals((int)55, (int)minute2.getMinute());
        MinuteTests.assertEquals((long)1016700900000L, (long)minute2.getFirstMillisecond(timeZone));
    }

    public void testSerialization() {
        Minute minute = new Minute();
        Minute minute2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(minute);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            minute2 = (Minute)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        MinuteTests.assertEquals((Object)minute, minute2);
    }

    public void testHashcode() {
        Minute minute = new Minute(45, 5, 1, 2, 2003);
        Minute minute2 = new Minute(45, 5, 1, 2, 2003);
        MinuteTests.assertTrue((boolean)minute.equals(minute2));
        int n = minute.hashCode();
        int n2 = minute2.hashCode();
        MinuteTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Minute minute = new Minute(45, 5, 1, 2, 2003);
        MinuteTests.assertFalse((boolean)(minute instanceof Cloneable));
    }
}

