/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;

public class DayTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DayTests.class);
    }

    public DayTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Day day = new Day();
        DayTests.assertTrue((boolean)day.equals(day));
    }

    public void testEquals() {
        Day day = new Day(29, 3, 2002);
        Day day2 = new Day(29, 3, 2002);
        DayTests.assertTrue((boolean)day.equals(day2));
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Day day = new Day(new Date(1078099199999L), timeZone);
        Day day2 = new Day(new Date(1078099200000L), timeZone);
        DayTests.assertEquals((int)2, (int)day.getMonth());
        DayTests.assertEquals((long)1078099199999L, (long)day.getLastMillisecond(timeZone));
        DayTests.assertEquals((int)3, (int)day2.getMonth());
        DayTests.assertEquals((long)1078099200000L, (long)day2.getFirstMillisecond(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Helsinki");
        Day day = new Day(new Date(1078091999999L), timeZone);
        Day day2 = new Day(new Date(1078092000000L), timeZone);
        DayTests.assertEquals((int)2, (int)day.getMonth());
        DayTests.assertEquals((long)1078091999999L, (long)day.getLastMillisecond(timeZone));
        DayTests.assertEquals((int)3, (int)day2.getMonth());
        DayTests.assertEquals((long)1078092000000L, (long)day2.getFirstMillisecond(timeZone));
    }

    public void test1Jan1900Previous() {
        Day day = new Day(1, 1, 1900);
        Day day2 = (Day)day.previous();
        DayTests.assertNull((Object)day2);
    }

    public void test1Jan1900Next() {
        Day day = new Day(1, 1, 1900);
        Day day2 = (Day)day.next();
        DayTests.assertEquals((int)2, (int)day2.getDayOfMonth());
    }

    public void test31Dec9999Previous() {
        Day day = new Day(31, 12, 9999);
        Day day2 = (Day)day.previous();
        DayTests.assertEquals((int)30, (int)day2.getDayOfMonth());
    }

    public void test31Dec9999Next() {
        Day day = new Day(31, 12, 9999);
        Day day2 = (Day)day.next();
        DayTests.assertNull((Object)day2);
    }

    public void testParseDay() throws ParseException {
        Day day;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2001, 12, 31);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = simpleDateFormat.parse("31/12/2001");
        if (date.equals(gregorianCalendar.getTime())) {
            day = Day.parseDay("31/12/2001");
            DayTests.assertEquals((int)37256, (int)day.getSerialDate().toSerial());
        }
        day = Day.parseDay("2001-12-31");
        DayTests.assertEquals((int)37256, (int)day.getSerialDate().toSerial());
    }

    public void testSerialization() {
        Day day = new Day(15, 4, 2000);
        Day day2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(day);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            day2 = (Day)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DayTests.assertEquals((Object)day, day2);
    }

    public void testHashcode() {
        Day day = new Day(1, 2, 2003);
        Day day2 = new Day(1, 2, 2003);
        DayTests.assertTrue((boolean)day.equals(day2));
        int n = day.hashCode();
        int n2 = day2.hashCode();
        DayTests.assertEquals((int)n, (int)n2);
    }

    public void testNotCloneable() {
        Day day = new Day(1, 2, 2003);
        DayTests.assertFalse((boolean)(day instanceof Cloneable));
    }
}

