/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.util.ObjectUtilities;

public class TimeSeries
extends Series
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5032960206869675528L;
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    protected List data;
    private int maximumItemCount;
    private int historyCount;

    public TimeSeries(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, Day.class);
    }

    public TimeSeries(String string, Class clazz) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(String string, String string2, String string3, Class clazz) {
        super((Comparable)((Object)string));
        this.domain = string2;
        this.range = string3;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.historyCount = 0;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
        while (this.data.size() > this.maximumItemCount) {
            this.data.remove(0);
        }
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int n) {
        this.historyCount = n;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataItem(int n) {
        return (TimeSeriesDataItem)this.data.get(n);
    }

    public TimeSeriesDataItem getDataItem(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'period' argument");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, -2.147483648E9);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n >= 0) {
            return (TimeSeriesDataItem)this.data.get(n);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n) {
        return this.getDataItem(n).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            arrayList.add(this.getTimePeriod(i));
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(i);
            int n = this.getIndex(regularTimePeriod);
            if (n >= 0) continue;
            arrayList.add(regularTimePeriod);
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, -2.147483648E9);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        return n;
    }

    public Number getValue(int n) {
        return this.getDataItem(n).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem) {
        if (timeSeriesDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        if (!timeSeriesDataItem.getPeriod().getClass().equals(this.timePeriodClass)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("You are trying to add data where the time period class ");
            stringBuffer.append("is ");
            stringBuffer.append(timeSeriesDataItem.getPeriod().getClass().getName());
            stringBuffer.append(", but the TimeSeries is expecting an instance of ");
            stringBuffer.append(this.timePeriodClass.getName());
            stringBuffer.append(".");
            throw new SeriesException(stringBuffer.toString());
        }
        boolean bl = false;
        int n = this.getItemCount();
        if (n == 0) {
            this.data.add(timeSeriesDataItem);
            bl = true;
        } else {
            RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
            if (timeSeriesDataItem.getPeriod().compareTo(regularTimePeriod) > 0) {
                this.data.add(timeSeriesDataItem);
                bl = true;
            } else {
                int n2 = Collections.binarySearch(this.data, timeSeriesDataItem);
                if (n2 < 0) {
                    this.data.add(-n2 - 1, timeSeriesDataItem);
                    bl = true;
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("You are attempting to add an observation for ");
                    stringBuffer.append("the time period ");
                    stringBuffer.append(timeSeriesDataItem.getPeriod().toString());
                    stringBuffer.append(" but the series already contains an observation");
                    stringBuffer.append(" for that time period. Duplicates are not ");
                    stringBuffer.append("permitted.  Try using the addOrUpdate() method.");
                    throw new SeriesException(stringBuffer.toString());
                }
            }
        }
        if (bl) {
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        }
    }

    public void add(RegularTimePeriod regularTimePeriod, double d) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, d);
        this.add(timeSeriesDataItem);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        this.add(timeSeriesDataItem);
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number):  period does not exist.");
        }
        TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)this.data.get(n);
        timeSeriesDataItem2.setValue(number);
        this.fireSeriesChanged();
    }

    public void update(int n, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = this.getDataItem(n);
        timeSeriesDataItem.setValue(number);
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries("Overwritten values from: " + this.getKey(), timeSeries.getTimePeriodClass());
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(i);
            TimeSeriesDataItem timeSeriesDataItem2 = this.addOrUpdate(timeSeriesDataItem.getPeriod(), timeSeriesDataItem.getValue());
            if (timeSeriesDataItem2 == null) continue;
            timeSeries2.add(timeSeriesDataItem2);
        }
        return timeSeries2;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, double d) {
        return this.addOrUpdate(regularTimePeriod, new Double(d));
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("Null 'period' argument.");
        }
        TimeSeriesDataItem timeSeriesDataItem = null;
        TimeSeriesDataItem timeSeriesDataItem2 = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem2);
        if (n >= 0) {
            TimeSeriesDataItem timeSeriesDataItem3 = (TimeSeriesDataItem)this.data.get(n);
            timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem3.clone();
            timeSeriesDataItem3.setValue(number);
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        } else {
            this.data.add(-n - 1, new TimeSeriesDataItem(regularTimePeriod, number));
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        }
        return timeSeriesDataItem;
    }

    public void ageHistoryCountItems() {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            long l = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
            while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void ageHistoryCountItems(long l) {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        this.data.remove(n);
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        for (int i = 0; i <= n2 - n; ++i) {
            this.data.remove(n);
        }
        this.fireSeriesChanged();
    }

    public Object clone() throws CloneNotSupportedException {
        TimeSeries timeSeries = this.createCopy(0, this.getItemCount() - 1);
        return timeSeries;
    }

    public TimeSeries createCopy(int n, int n2) throws CloneNotSupportedException {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(i);
                TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem.clone();
                try {
                    timeSeries.add(timeSeriesDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("Unable to add cloned data item.");
                }
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) throws CloneNotSupportedException {
        int n;
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        if ((n = this.getIndex(regularTimePeriod2)) < 0) {
            n = -(n + 1);
            --n;
        }
        TimeSeries timeSeries = this.createCopy(n2, n);
        return timeSeries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeries) || !super.equals(object)) {
            return false;
        }
        TimeSeries timeSeries = (TimeSeries)object;
        if (!ObjectUtilities.equal(this.getDomainDescription(), timeSeries.getDomainDescription())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getRangeDescription(), timeSeries.getRangeDescription())) {
            return false;
        }
        if (!this.getClass().equals(timeSeries.getClass())) {
            return false;
        }
        if (this.getHistoryCount() != timeSeries.getHistoryCount()) {
            return false;
        }
        if (this.getMaximumItemCount() != timeSeries.getMaximumItemCount()) {
            return false;
        }
        int n = this.getItemCount();
        if (n != timeSeries.getItemCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getDataItem(i).equals(timeSeries.getDataItem(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.domain != null ? this.domain.hashCode() : 0;
        n = 29 * n + (this.range != null ? this.range.hashCode() : 0);
        n = 29 * n + (this.timePeriodClass != null ? this.timePeriodClass.hashCode() : 0);
        n = 29 * n + ((Object)this.data).hashCode();
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + this.historyCount;
        return n;
    }
}

