/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.Statistics;

public class StatisticsTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StatisticsTests.class);
    }

    public StatisticsTests(String string) {
        super(string);
    }

    public void testCalculateMean1() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(9.0));
        arrayList.add(new Double(3.0));
        arrayList.add(new Double(2.0));
        arrayList.add(new Double(2.0));
        double d = Statistics.calculateMean(arrayList);
        StatisticsTests.assertEquals((double)4.0, (double)d, (double)1.0E-7);
    }

    public void testCalculateMean2() {
        Number[] numberArray = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        double d = Statistics.calculateMean(numberArray);
        StatisticsTests.assertEquals((double)2.0, (double)d, (double)1.0E-7);
    }

    public void testCalculateMedian1() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(1.0));
        double d = Statistics.calculateMedian(arrayList);
        StatisticsTests.assertEquals((double)1.0, (double)d, (double)1.0E-7);
    }

    public void testCalculateMedian2() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(2.0));
        arrayList.add(new Double(1.0));
        double d = Statistics.calculateMedian(arrayList);
        StatisticsTests.assertEquals((double)1.5, (double)d, (double)1.0E-7);
    }

    public void testCalculateMedian3() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(1.0));
        arrayList.add(new Double(2.0));
        arrayList.add(new Double(3.0));
        arrayList.add(new Double(6.0));
        arrayList.add(new Double(5.0));
        arrayList.add(new Double(4.0));
        double d = Statistics.calculateMedian(arrayList);
        StatisticsTests.assertEquals((double)3.5, (double)d, (double)1.0E-7);
    }

    public void testCalculateMedian4() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(7.0));
        arrayList.add(new Double(2.0));
        arrayList.add(new Double(3.0));
        arrayList.add(new Double(5.0));
        arrayList.add(new Double(4.0));
        arrayList.add(new Double(6.0));
        arrayList.add(new Double(1.0));
        double d = Statistics.calculateMedian(arrayList);
        StatisticsTests.assertEquals((double)4.0, (double)d, (double)1.0E-7);
    }

    public void testCalculateMedian5() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(11.228692993861783));
        arrayList.add(new Double(11.30823353859889));
        arrayList.add(new Double(11.75312904769314));
        arrayList.add(new Double(11.825102897465314));
        arrayList.add(new Double(10.184252778401783));
        arrayList.add(new Double(12.207951828057766));
        arrayList.add(new Double(10.68841994040566));
        arrayList.add(new Double(12.099522004479438));
        arrayList.add(new Double(11.508874945056881));
        arrayList.add(new Double(12.052517729558513));
        arrayList.add(new Double(12.401481645578734));
        arrayList.add(new Double(12.185377793028543));
        arrayList.add(new Double(10.666372951930315));
        arrayList.add(new Double(11.680978041499548));
        arrayList.add(new Double(11.06528277406718));
        arrayList.add(new Double(11.36876492904596));
        arrayList.add(new Double(11.927565516175939));
        arrayList.add(new Double(11.39307785978655));
        arrayList.add(new Double(11.989603679523857));
        arrayList.add(new Double(12.009834360354864));
        arrayList.add(new Double(10.653351822461559));
        arrayList.add(new Double(11.851776254376754));
        arrayList.add(new Double(11.045441544755946));
        arrayList.add(new Double(11.993674040560624));
        arrayList.add(new Double(12.898219965238944));
        arrayList.add(new Double(11.97095782819647));
        arrayList.add(new Double(11.73234406745488));
        arrayList.add(new Double(11.649006017243991));
        arrayList.add(new Double(12.20549704915365));
        arrayList.add(new Double(11.799723639384919));
        arrayList.add(new Double(11.896208658005628));
        arrayList.add(new Double(12.164149111823424));
        arrayList.add(new Double(12.042795103513766));
        arrayList.add(new Double(12.114839532596426));
        arrayList.add(new Double(12.166609097075824));
        arrayList.add(new Double(12.183017546225935));
        arrayList.add(new Double(11.622009125845342));
        arrayList.add(new Double(11.289365786738633));
        arrayList.add(new Double(12.462984323671568));
        arrayList.add(new Double(11.573494921030598));
        arrayList.add(new Double(10.862867940485804));
        arrayList.add(new Double(12.018186939664872));
        arrayList.add(new Double(10.418046849313018));
        arrayList.add(new Double(11.326344465881341));
        double d = Statistics.calculateMedian(arrayList, true);
        StatisticsTests.assertEquals((double)11.812413268425116, (double)d, (double)1.0E-6);
        Collections.sort(arrayList);
        double d2 = Statistics.calculateMedian(arrayList, false);
        StatisticsTests.assertEquals((double)11.812413268425116, (double)d2, (double)1.0E-6);
    }

    public void testCalculateMedian6() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(7.0));
        arrayList.add(new Double(2.0));
        arrayList.add(new Double(3.0));
        arrayList.add(new Double(5.0));
        arrayList.add(new Double(4.0));
        arrayList.add(new Double(6.0));
        arrayList.add(new Double(1.0));
        double d = Statistics.calculateMedian(arrayList, 0, 2);
        StatisticsTests.assertEquals((double)3.0, (double)d, (double)1.0E-7);
    }

    public void testCorrelation1() {
        Number[] numberArray = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        Number[] numberArray2 = new Number[]{new Double(1.0), new Double(2.0), new Double(3.0)};
        double d = Statistics.getCorrelation(numberArray, numberArray2);
        StatisticsTests.assertEquals((double)1.0, (double)d, (double)1.0E-8);
    }

    public void testCorrelation2() {
        Number[] numberArray = new Number[]{new Double(68.0), new Double(71.0), new Double(62.0), new Double(75.0), new Double(58.0), new Double(60.0), new Double(67.0), new Double(68.0), new Double(71.0), new Double(69.0), new Double(68.0), new Double(67.0), new Double(63.0), new Double(62.0), new Double(60.0), new Double(63.0), new Double(65.0), new Double(67.0), new Double(63.0), new Double(61.0)};
        Number[] numberArray2 = new Number[]{new Double(4.1), new Double(4.6), new Double(3.8), new Double(4.4), new Double(3.2), new Double(3.1), new Double(3.8), new Double(4.1), new Double(4.3), new Double(3.7), new Double(3.5), new Double(3.2), new Double(3.7), new Double(3.3), new Double(3.4), new Double(4.0), new Double(4.1), new Double(3.8), new Double(3.4), new Double(3.6)};
        double d = Statistics.getCorrelation(numberArray, numberArray2);
        StatisticsTests.assertEquals((double)0.7306356862792885, (double)d, (double)1.0E-12);
    }
}

