/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.SimpleHistogramBin;

public class SimpleHistogramBinTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleHistogramBinTests.class);
    }

    public SimpleHistogramBinTests(String string) {
        super(string);
    }

    public void testAccepts() {
        SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.accepts(0.0));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.accepts(1.0));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.accepts(1.5));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.accepts(2.0));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.accepts(2.1));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.accepts(Double.NaN));
        SimpleHistogramBin simpleHistogramBin2 = new SimpleHistogramBin(1.0, 2.0, false, false);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin2.accepts(0.0));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin2.accepts(1.0));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin2.accepts(1.5));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin2.accepts(2.0));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin2.accepts(2.1));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin2.accepts(Double.NaN));
    }

    public void testOverlapsWidth() {
        SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBin simpleHistogramBin2 = new SimpleHistogramBin(2.0, 3.0);
        SimpleHistogramBin simpleHistogramBin3 = new SimpleHistogramBin(3.0, 4.0);
        SimpleHistogramBin simpleHistogramBin4 = new SimpleHistogramBin(0.0, 5.0);
        SimpleHistogramBin simpleHistogramBin5 = new SimpleHistogramBin(2.0, 3.0, false, true);
        SimpleHistogramBin simpleHistogramBin6 = new SimpleHistogramBin(2.0, 3.0, true, false);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.overlapsWith(simpleHistogramBin2));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin2.overlapsWith(simpleHistogramBin));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.overlapsWith(simpleHistogramBin3));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin3.overlapsWith(simpleHistogramBin));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.overlapsWith(simpleHistogramBin4));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin4.overlapsWith(simpleHistogramBin));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.overlapsWith(simpleHistogramBin5));
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin5.overlapsWith(simpleHistogramBin));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.overlapsWith(simpleHistogramBin6));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin6.overlapsWith(simpleHistogramBin));
    }

    public void testEquals() {
        SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBin simpleHistogramBin2 = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin2.equals(simpleHistogramBin));
        simpleHistogramBin = new SimpleHistogramBin(1.1, 2.0, true, true);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2 = new SimpleHistogramBin(1.1, 2.0, true, true);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin = new SimpleHistogramBin(1.1, 2.2, true, true);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2 = new SimpleHistogramBin(1.1, 2.2, true, true);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin = new SimpleHistogramBin(1.1, 2.2, false, true);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2 = new SimpleHistogramBin(1.1, 2.2, false, true);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin = new SimpleHistogramBin(1.1, 2.2, false, false);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2 = new SimpleHistogramBin(1.1, 2.2, false, false);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin.setItemCount(99);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2.setItemCount(99);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
    }

    public void testCloning() {
        SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(1.1, 2.2, false, true);
        simpleHistogramBin.setItemCount(99);
        SimpleHistogramBin simpleHistogramBin2 = null;
        try {
            simpleHistogramBin2 = (SimpleHistogramBin)simpleHistogramBin.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        SimpleHistogramBinTests.assertTrue((simpleHistogramBin != simpleHistogramBin2 ? 1 : 0) != 0);
        SimpleHistogramBinTests.assertTrue((simpleHistogramBin.getClass() == simpleHistogramBin2.getClass() ? 1 : 0) != 0);
        SimpleHistogramBinTests.assertTrue((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
        simpleHistogramBin2.setItemCount(111);
        SimpleHistogramBinTests.assertFalse((boolean)simpleHistogramBin.equals(simpleHistogramBin2));
    }

    public void testSerialization() {
        SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(1.0, 2.0, false, true);
        simpleHistogramBin.setItemCount(123);
        SimpleHistogramBin simpleHistogramBin2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(simpleHistogramBin);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            simpleHistogramBin2 = (SimpleHistogramBin)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        SimpleHistogramBinTests.assertEquals((Object)simpleHistogramBin, simpleHistogramBin2);
    }
}

