/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.MeanAndStandardDeviation;

public class MeanAndStandardDeviationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MeanAndStandardDeviationTests.class);
    }

    public MeanAndStandardDeviationTests(String string) {
        super(string);
    }

    public void testEquals() {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(1.2, 3.4);
        MeanAndStandardDeviation meanAndStandardDeviation2 = new MeanAndStandardDeviation(1.2, 3.4);
        MeanAndStandardDeviationTests.assertTrue((boolean)meanAndStandardDeviation.equals(meanAndStandardDeviation2));
        MeanAndStandardDeviationTests.assertTrue((boolean)meanAndStandardDeviation2.equals(meanAndStandardDeviation));
        meanAndStandardDeviation = new MeanAndStandardDeviation(1.0, 3.4);
        MeanAndStandardDeviationTests.assertFalse((boolean)meanAndStandardDeviation.equals(meanAndStandardDeviation2));
        meanAndStandardDeviation2 = new MeanAndStandardDeviation(1.0, 3.4);
        MeanAndStandardDeviationTests.assertTrue((boolean)meanAndStandardDeviation.equals(meanAndStandardDeviation2));
        meanAndStandardDeviation = new MeanAndStandardDeviation(1.0, 3.0);
        MeanAndStandardDeviationTests.assertFalse((boolean)meanAndStandardDeviation.equals(meanAndStandardDeviation2));
        meanAndStandardDeviation2 = new MeanAndStandardDeviation(1.0, 3.0);
        MeanAndStandardDeviationTests.assertTrue((boolean)meanAndStandardDeviation.equals(meanAndStandardDeviation2));
    }

    public void testCloning() {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(1.2, 3.4);
        MeanAndStandardDeviationTests.assertFalse((boolean)(meanAndStandardDeviation instanceof Cloneable));
    }

    public void testSerialization() {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(1.2, 3.4);
        MeanAndStandardDeviation meanAndStandardDeviation2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(meanAndStandardDeviation);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            meanAndStandardDeviation2 = (MeanAndStandardDeviation)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        MeanAndStandardDeviationTests.assertEquals((Object)meanAndStandardDeviation, meanAndStandardDeviation2);
    }
}

