/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.HistogramDataset;

public class HistogramDatasetTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(HistogramDatasetTests.class);
    }

    public HistogramDatasetTests(String string) {
        super(string);
    }

    public void testBins() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 12.0, 5.0, 6.3, 4.5};
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.addSeries((Comparable)((Object)"Series 1"), dArray, 5);
        HistogramDatasetTests.assertEquals((double)histogramDataset.getYValue(0, 0), (double)3.0, (double)1.0E-10);
        HistogramDatasetTests.assertEquals((double)histogramDataset.getYValue(0, 1), (double)3.0, (double)1.0E-10);
        HistogramDatasetTests.assertEquals((double)histogramDataset.getYValue(0, 2), (double)2.0, (double)1.0E-10);
        HistogramDatasetTests.assertEquals((double)histogramDataset.getYValue(0, 3), (double)0.0, (double)1.0E-10);
        HistogramDatasetTests.assertEquals((double)histogramDataset.getYValue(0, 4), (double)1.0, (double)1.0E-10);
    }

    public void testEquals() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 12.0, 5.0, 6.3, 4.5};
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.addSeries((Comparable)((Object)"Series 1"), dArray, 5);
        HistogramDataset histogramDataset2 = new HistogramDataset();
        histogramDataset2.addSeries((Comparable)((Object)"Series 1"), dArray, 5);
        HistogramDatasetTests.assertTrue((boolean)histogramDataset.equals(histogramDataset2));
        HistogramDatasetTests.assertTrue((boolean)histogramDataset2.equals(histogramDataset));
    }

    public void testCloning() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 12.0, 5.0, 6.3, 4.5};
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.addSeries((Comparable)((Object)"Series 1"), dArray, 5);
        HistogramDataset histogramDataset2 = null;
        try {
            histogramDataset2 = (HistogramDataset)histogramDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        HistogramDatasetTests.assertTrue((histogramDataset != histogramDataset2 ? 1 : 0) != 0);
        HistogramDatasetTests.assertTrue((histogramDataset.getClass() == histogramDataset2.getClass() ? 1 : 0) != 0);
        HistogramDatasetTests.assertTrue((boolean)histogramDataset.equals(histogramDataset2));
    }

    public void testSerialization() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 12.0, 5.0, 6.3, 4.5};
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.addSeries((Comparable)((Object)"Series 1"), dArray, 5);
        HistogramDataset histogramDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(histogramDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            histogramDataset2 = (HistogramDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        HistogramDatasetTests.assertEquals((Object)histogramDataset, histogramDataset2);
    }
}

