/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;

public class DefaultStatisticalCategoryDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultStatisticalCategoryDatasetTests.class);
    }

    public DefaultStatisticalCategoryDatasetTests(String string) {
        super(string);
    }

    public void testEquals() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset2 = new DefaultStatisticalCategoryDataset();
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)defaultStatisticalCategoryDataset.equals(defaultStatisticalCategoryDataset2));
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)defaultStatisticalCategoryDataset2.equals(defaultStatisticalCategoryDataset));
    }

    public void testCloning() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        defaultStatisticalCategoryDataset.add(1.1, 2.2, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        defaultStatisticalCategoryDataset.add(3.3, 4.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        defaultStatisticalCategoryDataset.add(null, new Double(5.5), (Comparable)((Object)"R1"), (Comparable)((Object)"C3"));
        defaultStatisticalCategoryDataset.add(new Double(6.6), null, (Comparable)((Object)"R2"), (Comparable)((Object)"C3"));
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset2 = null;
        try {
            defaultStatisticalCategoryDataset2 = (DefaultStatisticalCategoryDataset)defaultStatisticalCategoryDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            DefaultStatisticalCategoryDatasetTests.fail((String)cloneNotSupportedException.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertTrue((defaultStatisticalCategoryDataset != defaultStatisticalCategoryDataset2 ? 1 : 0) != 0);
        DefaultStatisticalCategoryDatasetTests.assertTrue((defaultStatisticalCategoryDataset.getClass() == defaultStatisticalCategoryDataset2.getClass() ? 1 : 0) != 0);
        DefaultStatisticalCategoryDatasetTests.assertTrue((boolean)defaultStatisticalCategoryDataset.equals(defaultStatisticalCategoryDataset2));
    }

    public void testSerialization1() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        defaultStatisticalCategoryDataset.add(1.1, 2.2, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        defaultStatisticalCategoryDataset.add(3.3, 4.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        defaultStatisticalCategoryDataset.add(null, new Double(5.5), (Comparable)((Object)"R1"), (Comparable)((Object)"C3"));
        defaultStatisticalCategoryDataset.add(new Double(6.6), null, (Comparable)((Object)"R2"), (Comparable)((Object)"C3"));
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultStatisticalCategoryDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultStatisticalCategoryDataset2 = (DefaultStatisticalCategoryDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            DefaultStatisticalCategoryDatasetTests.fail((String)exception.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertEquals((Object)defaultStatisticalCategoryDataset, defaultStatisticalCategoryDataset2);
    }

    public void testSerialization2() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        defaultStatisticalCategoryDataset.add(1.2, 3.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultStatisticalCategoryDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultStatisticalCategoryDataset2 = (DefaultStatisticalCategoryDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            DefaultStatisticalCategoryDatasetTests.fail((String)exception.toString());
        }
        DefaultStatisticalCategoryDatasetTests.assertEquals((Object)defaultStatisticalCategoryDataset, defaultStatisticalCategoryDataset2);
    }
}

