/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class HistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6341668077370231153L;
    private List list = new ArrayList();
    private HistogramType type = HistogramType.FREQUENCY;

    public HistogramType getType() {
        return this.type;
    }

    public void setType(HistogramType histogramType) {
        if (histogramType == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = histogramType;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(Comparable comparable, double[] dArray, int n) {
        double d = this.getMinimum(dArray);
        double d2 = this.getMaximum(dArray);
        this.addSeries(comparable, dArray, n, d, d2);
    }

    public void addSeries(Comparable comparable, double[] dArray, int n, double d, double d2) {
        int n2;
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("The 'bins' value must be at least 1.");
        }
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        ArrayList<HistogramBin> arrayList = new ArrayList<HistogramBin>(n);
        for (n2 = 0; n2 < n; ++n2) {
            HistogramBin histogramBin = n2 == n - 1 ? new HistogramBin(d4, d2) : new HistogramBin(d4, d4 + d3);
            d4 += d3;
            arrayList.add(histogramBin);
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            int n3 = n - 1;
            if (dArray[n2] < d2) {
                double d5 = (dArray[n2] - d) / (d2 - d);
                n3 = (int)(d5 * (double)n);
            }
            HistogramBin histogramBin = (HistogramBin)arrayList.get(n3);
            histogramBin.incrementCount();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", comparable);
        hashMap.put("bins", arrayList);
        hashMap.put("values.length", new Integer(dArray.length));
        hashMap.put("bin width", new Double(d3));
        this.list.add(hashMap);
    }

    private double getMinimum(double[] dArray) {
        if (dArray == null || dArray.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private double getMaximum(double[] dArray) {
        if (dArray == null || dArray.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    List getBins(int n) {
        Map map = (Map)this.list.get(n);
        return (List)map.get("bins");
    }

    private int getTotal(int n) {
        Map map = (Map)this.list.get(n);
        return (Integer)map.get("values.length");
    }

    private double getBinWidth(int n) {
        Map map = (Map)this.list.get(n);
        return (Double)map.get("bin width");
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public Comparable getSeriesKey(int n) {
        Map map = (Map)this.list.get(n);
        return (String)map.get("name");
    }

    public int getItemCount(int n) {
        return this.getBins(n).size();
    }

    public Number getX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        double d = (histogramBin.getStartBoundary() + histogramBin.getEndBoundary()) / 2.0;
        return new Double(d);
    }

    public Number getY(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        double d = this.getTotal(n);
        double d2 = this.getBinWidth(n);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(histogramBin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)histogramBin.getCount() / d);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)histogramBin.getCount() / (d2 * d));
        }
        throw new IllegalStateException();
    }

    public Number getStartX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        return new Double(histogramBin.getStartBoundary());
    }

    public Number getEndX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        return new Double(histogramBin.getEndBoundary());
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HistogramDataset)) {
            return false;
        }
        HistogramDataset histogramDataset = (HistogramDataset)object;
        if (!ObjectUtilities.equal(this.type, histogramDataset.type)) {
            return false;
        }
        return ObjectUtilities.equal(this.list, histogramDataset.list);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

