/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MeanAndStandardDeviation;
import org.jfree.data.statistics.StatisticalCategoryDataset;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo {
    private KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = 0.0;
    private double maximumRangeValue = 0.0;
    private Range rangeBounds = new Range(0.0, 0.0);

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getValue(int n, int n2) {
        return this.getMeanValue(n, n2);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(comparable, comparable2);
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getStdDevValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public Number getStdDevValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double d, double d2, Comparable comparable, Comparable comparable2) {
        this.add(new Double(d), new Double(d2), comparable, comparable2);
    }

    public void add(Number number, Number number2, Comparable comparable, Comparable comparable2) {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(number, number2);
        this.data.addObject(meanAndStandardDeviation, comparable, comparable2);
        double d = 0.0;
        double d2 = 0.0;
        if (number != null) {
            d = number.doubleValue();
        }
        if (number2 != null) {
            d2 = number2.doubleValue();
        }
        if (d + d2 > this.maximumRangeValue) {
            this.maximumRangeValue = d + d2;
            this.rangeBounds = new Range(this.minimumRangeValue, this.maximumRangeValue);
        }
        if (d - d2 < this.minimumRangeValue) {
            this.minimumRangeValue = d - d2;
            this.rangeBounds = new Range(this.minimumRangeValue, this.maximumRangeValue);
        }
        this.fireDatasetChanged();
    }

    public double getRangeLowerBound(boolean bl) {
        return this.minimumRangeValue;
    }

    public double getRangeUpperBound(boolean bl) {
        return this.maximumRangeValue;
    }

    public Range getRangeBounds(boolean bl) {
        return this.rangeBounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultStatisticalCategoryDataset)) {
            return false;
        }
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = (DefaultStatisticalCategoryDataset)object;
        return this.data.equals(defaultStatisticalCategoryDataset.data);
    }
}

