/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.Range;

public class RangeTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(RangeTests.class);
    }

    public RangeTests(String string) {
        super(string);
    }

    public void testEquals() {
        Range range = new Range(0.0, 1.0);
        Range range2 = new Range(0.0, 1.0);
        RangeTests.assertEquals((Object)range, (Object)range2);
        RangeTests.assertEquals((Object)range2, (Object)range);
        range = new Range(0.0, 1.0);
        range2 = new Range(0.5, 1.0);
        RangeTests.assertFalse((boolean)range.equals(range2));
        range = new Range(0.0, 1.0);
        range2 = new Range(0.0, 2.0);
        RangeTests.assertFalse((boolean)range.equals(range2));
    }

    public void testContains() {
        Range range = new Range(0.0, 1.0);
        RangeTests.assertFalse((boolean)range.contains(Double.NaN));
        RangeTests.assertFalse((boolean)range.contains(Double.NEGATIVE_INFINITY));
        RangeTests.assertFalse((boolean)range.contains(-1.0));
        RangeTests.assertTrue((boolean)range.contains(0.0));
        RangeTests.assertTrue((boolean)range.contains(0.5));
        RangeTests.assertTrue((boolean)range.contains(1.0));
        RangeTests.assertFalse((boolean)range.contains(2.0));
        RangeTests.assertFalse((boolean)range.contains(Double.POSITIVE_INFINITY));
    }

    public void testConstrain() {
        Range range = new Range(0.0, 1.0);
        double d = range.constrain(0.5);
        RangeTests.assertEquals((double)0.5, (double)d, (double)1.0E-7);
        d = range.constrain(0.0);
        RangeTests.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = range.constrain(1.0);
        RangeTests.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = range.constrain(-1.0);
        RangeTests.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = range.constrain(2.0);
        RangeTests.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = range.constrain(Double.POSITIVE_INFINITY);
        RangeTests.assertEquals((double)1.0, (double)d, (double)1.0E-7);
        d = range.constrain(Double.NEGATIVE_INFINITY);
        RangeTests.assertEquals((double)0.0, (double)d, (double)1.0E-7);
        d = range.constrain(Double.NaN);
        RangeTests.assertTrue((boolean)Double.isNaN(d));
    }

    public void testIntersects() {
        Range range = new Range(0.0, 1.0);
        RangeTests.assertFalse((boolean)range.intersects(-2.0, -1.0));
        RangeTests.assertFalse((boolean)range.intersects(-2.0, 0.0));
        RangeTests.assertTrue((boolean)range.intersects(-2.0, 0.5));
        RangeTests.assertTrue((boolean)range.intersects(-2.0, 1.0));
        RangeTests.assertTrue((boolean)range.intersects(-2.0, 1.5));
        RangeTests.assertTrue((boolean)range.intersects(0.0, 0.5));
        RangeTests.assertTrue((boolean)range.intersects(0.0, 1.0));
        RangeTests.assertTrue((boolean)range.intersects(0.0, 1.5));
        RangeTests.assertTrue((boolean)range.intersects(0.5, 0.6));
        RangeTests.assertTrue((boolean)range.intersects(0.5, 1.0));
        RangeTests.assertTrue((boolean)range.intersects(0.5, 1.5));
        RangeTests.assertFalse((boolean)range.intersects(1.0, 1.1));
        RangeTests.assertFalse((boolean)range.intersects(1.5, 2.0));
    }

    public void testExpand() {
        Range range = new Range(0.0, 100.0);
        Range range2 = Range.expand(range, 0.1, 0.1);
        RangeTests.assertEquals((double)-10.0, (double)range2.getLowerBound(), (double)0.001);
        RangeTests.assertEquals((double)110.0, (double)range2.getUpperBound(), (double)0.001);
    }

    public void testSerialization() {
        Range range = new Range(25.0, 133.42);
        Range range2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(range);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            range2 = (Range)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RangeTests.assertEquals((Object)range, range2);
    }
}

