/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObjects;

public class KeyedObjectsTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjectsTests.class);
    }

    public KeyedObjectsTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testCloning() {
        KeyedObjects keyedObjects = new KeyedObjects();
        keyedObjects.addObject((Comparable)((Object)"V1"), new Integer(1));
        keyedObjects.addObject((Comparable)((Object)"V2"), null);
        keyedObjects.addObject((Comparable)((Object)"V3"), new Integer(3));
        KeyedObjects keyedObjects2 = null;
        try {
            keyedObjects2 = (KeyedObjects)keyedObjects.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        KeyedObjectsTests.assertTrue((keyedObjects != keyedObjects2 ? 1 : 0) != 0);
        KeyedObjectsTests.assertTrue((keyedObjects.getClass() == keyedObjects2.getClass() ? 1 : 0) != 0);
        KeyedObjectsTests.assertTrue((boolean)keyedObjects.equals(keyedObjects2));
    }

    public void testInsertAndRetrieve() {
        KeyedObjects keyedObjects = new KeyedObjects();
        keyedObjects.addObject((Comparable)((Object)"A"), new Double(1.0));
        keyedObjects.addObject((Comparable)((Object)"B"), new Double(2.0));
        keyedObjects.addObject((Comparable)((Object)"C"), new Double(3.0));
        keyedObjects.addObject((Comparable)((Object)"D"), null);
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getKey(0), (Object)"A");
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getKey(1), (Object)"B");
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getKey(2), (Object)"C");
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getKey(3), (Object)"D");
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject((Comparable)((Object)"A")), (Object)new Double(1.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject((Comparable)((Object)"B")), (Object)new Double(2.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject((Comparable)((Object)"C")), (Object)new Double(3.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject((Comparable)((Object)"D")), null);
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject((Comparable)((Object)"Not a key")), null);
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject(0), (Object)new Double(1.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject(1), (Object)new Double(2.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject(2), (Object)new Double(3.0));
        KeyedObjectsTests.assertEquals((Object)keyedObjects.getObject(3), null);
    }

    public void testSerialization() {
        KeyedObjects keyedObjects = new KeyedObjects();
        keyedObjects.addObject((Comparable)((Object)"Key 1"), "Object 1");
        keyedObjects.addObject((Comparable)((Object)"Key 2"), null);
        keyedObjects.addObject((Comparable)((Object)"Key 3"), "Object 2");
        KeyedObjects keyedObjects2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(keyedObjects);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            keyedObjects2 = (KeyedObjects)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        KeyedObjectsTests.assertEquals((Object)keyedObjects, keyedObjects2);
    }
}

