/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObjects2D;

public class KeyedObjects2DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjects2DTests.class);
    }

    public KeyedObjects2DTests(String string) {
        super(string);
    }

    public void testCloning() {
        KeyedObjects2D keyedObjects2D = new KeyedObjects2D();
        keyedObjects2D.setObject(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        keyedObjects2D.setObject(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        keyedObjects2D.setObject(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        KeyedObjects2D keyedObjects2D2 = null;
        try {
            keyedObjects2D2 = (KeyedObjects2D)keyedObjects2D.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        KeyedObjects2DTests.assertTrue((keyedObjects2D != keyedObjects2D2 ? 1 : 0) != 0);
        KeyedObjects2DTests.assertTrue((keyedObjects2D.getClass() == keyedObjects2D2.getClass() ? 1 : 0) != 0);
        KeyedObjects2DTests.assertTrue((boolean)keyedObjects2D.equals(keyedObjects2D2));
    }

    public void testSerialization() {
        KeyedObjects2D keyedObjects2D = new KeyedObjects2D();
        keyedObjects2D.addObject(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        keyedObjects2D.addObject(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        keyedObjects2D.addObject(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        keyedObjects2D.addObject(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        KeyedObjects2D keyedObjects2D2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(keyedObjects2D);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            keyedObjects2D2 = (KeyedObjects2D)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        KeyedObjects2DTests.assertEquals((Object)keyedObjects2D, keyedObjects2D2);
    }
}

