/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyedObject;

public class KeyedObjectTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyedObjectTests.class);
    }

    public KeyedObjectTests(String string) {
        super(string);
    }

    public void testEquals() {
        KeyedObject keyedObject = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject keyedObject2 = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObjectTests.assertTrue((boolean)keyedObject.equals(keyedObject2));
        KeyedObjectTests.assertTrue((boolean)keyedObject2.equals(keyedObject));
        keyedObject = new KeyedObject((Comparable)((Object)"Test 1"), "Object");
        keyedObject2 = new KeyedObject((Comparable)((Object)"Test 2"), "Object");
        KeyedObjectTests.assertFalse((boolean)keyedObject.equals(keyedObject2));
        keyedObject = new KeyedObject((Comparable)((Object)"Test"), "Object 1");
        keyedObject2 = new KeyedObject((Comparable)((Object)"Test"), "Object 2");
        KeyedObjectTests.assertFalse((boolean)keyedObject.equals(keyedObject2));
    }

    public void testCloning() {
        KeyedObject keyedObject = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject keyedObject2 = null;
        try {
            keyedObject2 = (KeyedObject)keyedObject.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        KeyedObjectTests.assertTrue((keyedObject != keyedObject2 ? 1 : 0) != 0);
        KeyedObjectTests.assertTrue((keyedObject.getClass() == keyedObject2.getClass() ? 1 : 0) != 0);
        KeyedObjectTests.assertTrue((boolean)keyedObject.equals(keyedObject2));
    }

    public void testSerialization() {
        KeyedObject keyedObject = new KeyedObject((Comparable)((Object)"Test"), "Object");
        KeyedObject keyedObject2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(keyedObject);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            keyedObject2 = (KeyedObject)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        KeyedObjectTests.assertEquals((Object)keyedObject, keyedObject2);
    }
}

