/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractXYDataset
implements XYDataset,
TableXYDataset,
RangeInfo {
    private transient Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        this();
        Class.forName(string2);
        this.connection = DriverManager.getConnection(string, string3, string4);
    }

    public JDBCXYDataset(Connection connection) throws SQLException {
        this();
        this.connection = connection;
    }

    public JDBCXYDataset(Connection connection, String string) throws SQLException {
        this(connection);
        this.executeQuery(string);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean bl) {
        this.isTimeSeries = bl;
    }

    public void executeQuery(String string) throws SQLException {
        this.executeQuery(this.connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection connection, String string) throws SQLException {
        if (connection == null) {
            throw new SQLException("There is no database to execute the query.");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            int n;
            int n2;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            int n4 = 0;
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    n = resultSetMetaData.getColumnType(n2 + 1);
                    switch (n) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            ++n4;
                            nArray[n2] = n;
                            break;
                        }
                        default: {
                            Log.warn("Unable to load column " + n2 + " (" + n + "," + resultSetMetaData.getColumnClassName(n2 + 1) + ")");
                            nArray[n2] = 0;
                            break;
                        }
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    nArray[n2] = 0;
                    throw sQLException;
                }
            }
            if (n4 <= 1) {
                throw new SQLException("Not enough valid columns where generated by query.");
            }
            this.columnNames = new String[n4 - 1];
            n2 = 0;
            for (n = 1; n < n3; ++n) {
                if (nArray[n] == 0) continue;
                this.columnNames[n2] = resultSetMetaData.getColumnLabel(n + 1);
                ++n2;
            }
            if (this.rows != null) {
                for (n = 0; n < this.rows.size(); ++n) {
                    ArrayList arrayList = (ArrayList)this.rows.get(n);
                    arrayList.clear();
                }
                this.rows.clear();
            }
            switch (nArray[0]) {
                case 91: 
                case 92: 
                case 93: {
                    this.isTimeSeries = true;
                    break;
                }
                default: {
                    this.isTimeSeries = false;
                }
            }
            while (resultSet.next()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                block28: for (int i = 0; i < n3; ++i) {
                    Object object = resultSet.getObject(i + 1);
                    switch (nArray[i]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            arrayList.add(object);
                            continue block28;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            arrayList.add(new Long(((Date)object).getTime()));
                            continue block28;
                        }
                        case 0: {
                            continue block28;
                        }
                        default: {
                            System.err.println("Unknown data");
                            nArray[i] = 0;
                        }
                    }
                }
                this.rows.add(arrayList);
            }
            if (this.rows.size() == 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < n3; ++i) {
                    if (nArray[i] == 0) continue;
                    arrayList.add(new Integer(0));
                }
                this.rows.add(arrayList);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                ArrayList arrayList = (ArrayList)this.rows.get(0);
                this.maxValue = Double.NEGATIVE_INFINITY;
                this.minValue = Double.POSITIVE_INFINITY;
                for (int i = 0; i < this.rows.size(); ++i) {
                    arrayList = (ArrayList)this.rows.get(i);
                    for (int j = 1; j < n3; ++j) {
                        Object e = arrayList.get(j);
                        if (e == null) continue;
                        double d = ((Number)e).doubleValue();
                        if (d < this.minValue) {
                            this.minValue = d;
                        }
                        if (!(d > this.maxValue)) continue;
                        this.maxValue = d;
                    }
                }
            }
            this.fireDatasetChanged();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Number getX(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.rows.get(n2);
        return (Number)arrayList.get(0);
    }

    public Number getY(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.rows.get(n2);
        return (Number)arrayList.get(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getItemCount() {
        return this.getItemCount(0);
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public Comparable getSeriesKey(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public double getRangeLowerBound(boolean bl) {
        return this.minValue;
    }

    public double getRangeUpperBound(boolean bl) {
        return this.maxValue;
    }

    public Range getRangeBounds(boolean bl) {
        return new Range(this.minValue, this.maxValue);
    }
}

