/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.DefaultPieDataset;

public class DefaultPieDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultPieDatasetTests.class);
    }

    public DefaultPieDatasetTests(String string) {
        super(string);
    }

    public void testCloning() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"V1"), new Integer(1));
        defaultPieDataset.setValue((Comparable)((Object)"V2"), null);
        defaultPieDataset.setValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultPieDataset defaultPieDataset2 = null;
        try {
            defaultPieDataset2 = (DefaultPieDataset)defaultPieDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultPieDatasetTests.assertTrue((defaultPieDataset != defaultPieDataset2 ? 1 : 0) != 0);
        DefaultPieDatasetTests.assertTrue((defaultPieDataset.getClass() == defaultPieDataset2.getClass() ? 1 : 0) != 0);
        DefaultPieDatasetTests.assertTrue((boolean)defaultPieDataset.equals(defaultPieDataset2));
    }

    public void testSerialization() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"C1"), new Double(234.2));
        defaultPieDataset.setValue((Comparable)((Object)"C2"), null);
        defaultPieDataset.setValue((Comparable)((Object)"C3"), new Double(345.9));
        defaultPieDataset.setValue((Comparable)((Object)"C4"), new Double(452.7));
        DefaultPieDataset defaultPieDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultPieDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultPieDataset2 = (DefaultPieDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultPieDatasetTests.assertEquals((Object)defaultPieDataset, defaultPieDataset2);
    }
}

