/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class DefaultKeyedValues2DDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValues2DDatasetTests.class);
    }

    public DefaultKeyedValues2DDatasetTests(String string) {
        super(string);
    }

    public void testCloning() {
        DefaultKeyedValues2DDataset defaultKeyedValues2DDataset = new DefaultKeyedValues2DDataset();
        defaultKeyedValues2DDataset.setValue(new Integer(1), (Comparable)((Object)"V1"), (Comparable)((Object)"C1"));
        defaultKeyedValues2DDataset.setValue(null, (Comparable)((Object)"V2"), (Comparable)((Object)"C1"));
        defaultKeyedValues2DDataset.setValue(new Integer(3), (Comparable)((Object)"V3"), (Comparable)((Object)"C2"));
        DefaultKeyedValues2DDataset defaultKeyedValues2DDataset2 = null;
        try {
            defaultKeyedValues2DDataset2 = (DefaultKeyedValues2DDataset)defaultKeyedValues2DDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValues2DDatasetTests.assertTrue((defaultKeyedValues2DDataset != defaultKeyedValues2DDataset2 ? 1 : 0) != 0);
        DefaultKeyedValues2DDatasetTests.assertTrue((defaultKeyedValues2DDataset.getClass() == defaultKeyedValues2DDataset2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValues2DDatasetTests.assertTrue((boolean)defaultKeyedValues2DDataset.equals(defaultKeyedValues2DDataset2));
    }

    public void testSerialization() {
        DefaultKeyedValues2DDataset defaultKeyedValues2DDataset = new DefaultKeyedValues2DDataset();
        defaultKeyedValues2DDataset.addValue(new Double(234.2), (Comparable)((Object)"Row1"), (Comparable)((Object)"Col1"));
        defaultKeyedValues2DDataset.addValue(null, (Comparable)((Object)"Row1"), (Comparable)((Object)"Col2"));
        defaultKeyedValues2DDataset.addValue(new Double(345.9), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col1"));
        defaultKeyedValues2DDataset.addValue(new Double(452.7), (Comparable)((Object)"Row2"), (Comparable)((Object)"Col2"));
        DefaultKeyedValues2DDataset defaultKeyedValues2DDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValues2DDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultKeyedValues2DDataset2 = (DefaultKeyedValues2DDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValues2DDatasetTests.assertEquals((Object)defaultKeyedValues2DDataset, defaultKeyedValues2DDataset2);
    }
}

