/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.DefaultKeyedValueDataset;

public class DefaultKeyedValueDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValueDatasetTests.class);
    }

    public DefaultKeyedValueDatasetTests(String string) {
        super(string);
    }

    public void testEquals() {
        DefaultKeyedValueDataset defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueDataset defaultKeyedValueDataset2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueDatasetTests.assertTrue((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
        DefaultKeyedValueDatasetTests.assertTrue((boolean)defaultKeyedValueDataset2.equals(defaultKeyedValueDataset));
        defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Test 1"), new Double(45.5));
        defaultKeyedValueDataset2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test 2"), new Double(45.5));
        DefaultKeyedValueDatasetTests.assertFalse((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
        defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        defaultKeyedValueDataset2 = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.6));
        DefaultKeyedValueDatasetTests.assertFalse((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
    }

    public void testCloning() {
        DefaultKeyedValueDataset defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(45.5));
        DefaultKeyedValueDataset defaultKeyedValueDataset2 = null;
        try {
            defaultKeyedValueDataset2 = (DefaultKeyedValueDataset)defaultKeyedValueDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValueDatasetTests.assertTrue((defaultKeyedValueDataset != defaultKeyedValueDataset2 ? 1 : 0) != 0);
        DefaultKeyedValueDatasetTests.assertTrue((defaultKeyedValueDataset.getClass() == defaultKeyedValueDataset2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValueDatasetTests.assertTrue((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
    }

    public void testCloneIndependence() {
        DefaultKeyedValueDataset defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Key"), new Double(10.0));
        DefaultKeyedValueDataset defaultKeyedValueDataset2 = null;
        try {
            defaultKeyedValueDataset2 = (DefaultKeyedValueDataset)defaultKeyedValueDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValueDatasetTests.assertTrue((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
        defaultKeyedValueDataset2.updateValue(new Double(99.9));
        DefaultKeyedValueDatasetTests.assertFalse((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
        defaultKeyedValueDataset2.updateValue(new Double(10.0));
        DefaultKeyedValueDatasetTests.assertTrue((boolean)defaultKeyedValueDataset.equals(defaultKeyedValueDataset2));
    }

    public void testSerialization() {
        DefaultKeyedValueDataset defaultKeyedValueDataset = new DefaultKeyedValueDataset((Comparable)((Object)"Test"), new Double(25.3));
        DefaultKeyedValueDataset defaultKeyedValueDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValueDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultKeyedValueDataset2 = (DefaultKeyedValueDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValueDatasetTests.assertEquals((Object)defaultKeyedValueDataset, defaultKeyedValueDataset2);
    }
}

