/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.Set;
import java.util.TreeSet;
import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.general.AbstractDataset;

public class WaferMapDataset
extends AbstractDataset {
    private DefaultKeyedValues2D data;
    private int maxChipX;
    private int maxChipY;
    private double chipSpace;
    private Double maxValue = new Double(Double.NEGATIVE_INFINITY);
    private Double minValue = new Double(Double.POSITIVE_INFINITY);
    private static final double DEFAULT_CHIP_SPACE = 1.0;

    public WaferMapDataset(int n, int n2) {
        this(n, n2, null);
    }

    public WaferMapDataset(int n, int n2, Number number) {
        this.data = new DefaultKeyedValues2D();
        this.maxChipX = n;
        this.maxChipY = n2;
        this.chipSpace = number == null ? 1.0 : number.doubleValue();
    }

    public void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void addValue(int n, int n2, int n3) {
        this.setValue(new Double(n), new Integer(n2), new Integer(n3));
    }

    public void setValue(Number number, Comparable comparable, Comparable comparable2) {
        this.data.setValue(number, comparable, comparable2);
        if (this.isMaxValue(number)) {
            this.maxValue = (Double)number;
        }
        if (this.isMinValue(number)) {
            this.minValue = (Double)number;
        }
    }

    public int getUniqueValueCount() {
        return this.getUniqueValues().size();
    }

    public Set getUniqueValues() {
        TreeSet<Number> treeSet = new TreeSet<Number>();
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            for (int j = 0; j < this.data.getColumnCount(); ++j) {
                Number number = this.data.getValue(i, j);
                if (number == null) continue;
                treeSet.add(number);
            }
        }
        return treeSet;
    }

    public Number getChipValue(int n, int n2) {
        return this.getChipValue(new Integer(n), new Integer(n2));
    }

    public Number getChipValue(Comparable comparable, Comparable comparable2) {
        int n = this.data.getRowIndex(comparable);
        if (n < 0) {
            return null;
        }
        int n2 = this.data.getColumnIndex(comparable2);
        if (n2 < 0) {
            return null;
        }
        return this.data.getValue(n, n2);
    }

    public boolean isMaxValue(Number number) {
        return number.doubleValue() > this.maxValue;
    }

    public boolean isMinValue(Number number) {
        return number.doubleValue() < this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public int getMaxChipX() {
        return this.maxChipX;
    }

    public void setMaxChipX(int n) {
        this.maxChipX = n;
    }

    public int getMaxChipY() {
        return this.maxChipY;
    }

    public void setMaxChipY(int n) {
        this.maxChipY = n;
    }

    public double getChipSpace() {
        return this.chipSpace;
    }

    public void setChipSpace(double d) {
        this.chipSpace = d;
    }
}

