/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.time.SimpleTimePeriod;

public class TaskTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskTests.class);
    }

    public TaskTests(String string) {
        super(string);
    }

    public void testEquals() {
        Task task = new Task("T", new Date(1L), new Date(2L));
        Task task2 = new Task("T", new Date(1L), new Date(2L));
        TaskTests.assertTrue((boolean)task.equals(task2));
        TaskTests.assertTrue((boolean)task2.equals(task));
        task.setDescription("X");
        TaskTests.assertFalse((boolean)task.equals(task2));
        task2.setDescription("X");
        TaskTests.assertTrue((boolean)task.equals(task2));
        task.setDuration(new SimpleTimePeriod(new Date(2L), new Date(3L)));
        TaskTests.assertFalse((boolean)task.equals(task2));
        task2.setDuration(new SimpleTimePeriod(new Date(2L), new Date(3L)));
        TaskTests.assertTrue((boolean)task.equals(task2));
        task.setPercentComplete(0.5);
        TaskTests.assertFalse((boolean)task.equals(task2));
        task2.setPercentComplete(0.5);
        TaskTests.assertTrue((boolean)task.equals(task2));
        task.addSubtask(new Task("T", new Date(22L), new Date(33L)));
        TaskTests.assertFalse((boolean)task.equals(task2));
        task2.addSubtask(new Task("T", new Date(22L), new Date(33L)));
        TaskTests.assertTrue((boolean)task.equals(task2));
    }

    public void testCloning() {
        Task task = new Task("T", new Date(1L), new Date(2L));
        Task task2 = null;
        try {
            task2 = (Task)task.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        TaskTests.assertTrue((task != task2 ? 1 : 0) != 0);
        TaskTests.assertTrue((task.getClass() == task2.getClass() ? 1 : 0) != 0);
        TaskTests.assertTrue((boolean)task.equals(task2));
    }

    public void testSerialization() {
        Task task = new Task("T", new Date(1L), new Date(2L));
        Task task2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(task);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            task2 = (Task)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TaskTests.assertEquals((Object)task, task2);
    }

    public void testGetSubTaskCount() {
        Task task = new Task("T", new Date(100L), new Date(200L));
        TaskTests.assertEquals((int)0, (int)task.getSubtaskCount());
        task.addSubtask(new Task("S1", new Date(100L), new Date(110L)));
        TaskTests.assertEquals((int)1, (int)task.getSubtaskCount());
        Task task2 = new Task("S2", new Date(111L), new Date(120L));
        task.addSubtask(task2);
        TaskTests.assertEquals((int)2, (int)task.getSubtaskCount());
        task.addSubtask(new Task("S3", new Date(121L), new Date(130L)));
        TaskTests.assertEquals((int)3, (int)task.getSubtaskCount());
        task.removeSubtask(task2);
        TaskTests.assertEquals((int)2, (int)task.getSubtaskCount());
    }
}

