/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyToGroupMap;

public class KeyToGroupMapTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(KeyToGroupMapTests.class);
    }

    public KeyToGroupMapTests(String string) {
        super(string);
    }

    public void testMapKeyToGroup() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((Object)"G2", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K2")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K2"), null);
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K2")));
        boolean bl = false;
        try {
            keyToGroupMap.mapKeyToGroup(null, (Comparable)((Object)"G1"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        KeyToGroupMapTests.assertTrue((boolean)bl);
    }

    public void testGroupCount() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)1, (int)keyToGroupMap.getGroupCount());
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getGroupCount());
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C2"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getGroupCount());
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C3"), (Comparable)((Object)"Default Group"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C6"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)3, (int)keyToGroupMap.getGroupCount());
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C4"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"C5"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getGroupCount());
    }

    public void testKeyCount() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)0, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"Default Group")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)1, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"G1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), null);
        KeyToGroupMapTests.assertEquals((int)0, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"G1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)1, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"Default Group")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K3"), (Comparable)((Object)"Default Group"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K4"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K5"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K6"), (Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)3, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"Default Group")));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"G2")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K4"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K5"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"G1")));
        KeyToGroupMapTests.assertEquals((int)0, (int)keyToGroupMap.getKeyCount((Comparable)((Object)"G2")));
    }

    public void testGetGroupIndex() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((int)0, (int)keyToGroupMap.getGroupIndex((Comparable)((Object)"Default Group")));
        KeyToGroupMapTests.assertEquals((int)-1, (int)keyToGroupMap.getGroupIndex((Comparable)((Object)"G3")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K3"), (Comparable)((Object)"G3"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K2"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((int)1, (int)keyToGroupMap.getGroupIndex((Comparable)((Object)"G3")));
        KeyToGroupMapTests.assertEquals((int)2, (int)keyToGroupMap.getGroupIndex((Comparable)((Object)"G1")));
        KeyToGroupMapTests.assertEquals((int)3, (int)keyToGroupMap.getGroupIndex((Comparable)((Object)"G2")));
    }

    public void testGetGroup() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertEquals((Object)"Default Group", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertEquals((Object)"G1", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertEquals((Object)"G2", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K1")));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), null);
        KeyToGroupMapTests.assertEquals((Object)"Default Group", (Object)keyToGroupMap.getGroup((Comparable)((Object)"K1")));
        boolean bl = false;
        try {
            Comparable comparable = keyToGroupMap.getGroup(null);
            System.out.println(comparable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        KeyToGroupMapTests.assertTrue((boolean)bl);
    }

    public void testEquals() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMap keyToGroupMap2 = new KeyToGroupMap((Comparable)((Object)"Default Group"));
        KeyToGroupMapTests.assertTrue((boolean)keyToGroupMap.equals(keyToGroupMap2));
        KeyToGroupMapTests.assertTrue((boolean)keyToGroupMap2.equals(keyToGroupMap));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertFalse((boolean)keyToGroupMap.equals(keyToGroupMap2));
        keyToGroupMap2.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMapTests.assertTrue((boolean)keyToGroupMap.equals(keyToGroupMap2));
    }

    public void testCloning() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Test"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G1"));
        KeyToGroupMap keyToGroupMap2 = null;
        try {
            keyToGroupMap2 = (KeyToGroupMap)keyToGroupMap.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        KeyToGroupMapTests.assertTrue((keyToGroupMap != keyToGroupMap2 ? 1 : 0) != 0);
        KeyToGroupMapTests.assertTrue((keyToGroupMap.getClass() == keyToGroupMap2.getClass() ? 1 : 0) != 0);
        KeyToGroupMapTests.assertTrue((boolean)keyToGroupMap.equals(keyToGroupMap2));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertFalse((boolean)keyToGroupMap.equals(keyToGroupMap2));
        keyToGroupMap2.mapKeyToGroup((Comparable)((Object)"K1"), (Comparable)((Object)"G2"));
        KeyToGroupMapTests.assertTrue((boolean)keyToGroupMap.equals(keyToGroupMap2));
    }

    public void testSerialization() {
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"Test"));
        KeyToGroupMap keyToGroupMap2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(keyToGroupMap);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            keyToGroupMap2 = (KeyToGroupMap)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        KeyToGroupMapTests.assertEquals((Object)keyToGroupMap, keyToGroupMap2);
    }
}

