/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.general.DefaultPieDataset;

public class StandardPieURLGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieURLGeneratorTests.class);
    }

    public StandardPieURLGeneratorTests(String string) {
        super(string);
    }

    public void testSerialization() {
        StandardPieURLGenerator standardPieURLGenerator = new StandardPieURLGenerator("index.html?", "cat");
        StandardPieURLGenerator standardPieURLGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(standardPieURLGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            standardPieURLGenerator2 = (StandardPieURLGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StandardPieURLGeneratorTests.assertEquals((Object)standardPieURLGenerator, standardPieURLGenerator2);
    }

    public void testURL() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Alpha"), new Double(5.0));
        defaultPieDataset.setValue((Comparable)((Object)"Beta"), new Double(5.5));
        StandardPieURLGenerator standardPieURLGenerator = new StandardPieURLGenerator("chart.jsp", "category");
        String string = standardPieURLGenerator.generateURL(defaultPieDataset, (Comparable)((Object)"Beta"), 0);
        StandardPieURLGeneratorTests.assertEquals((String)"chart.jsp?category=Beta&amp;pieIndex=0", (String)string);
    }
}

