/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.title.TextTitle;

public class TextTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TextTitleTests.class);
    }

    public TextTitleTests(String string) {
        super(string);
    }

    public void testEquals() {
        TextTitle textTitle = new TextTitle();
        TextTitle textTitle2 = new TextTitle();
        TextTitleTests.assertEquals((Object)textTitle, (Object)textTitle2);
        textTitle.setText("Test 1");
        TextTitleTests.assertFalse((boolean)textTitle.equals(textTitle2));
        textTitle2.setText("Test 1");
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
        Font font = new Font("SansSerif", 0, 15);
        textTitle.setFont(font);
        TextTitleTests.assertFalse((boolean)textTitle.equals(textTitle2));
        textTitle2.setFont(font);
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
        textTitle.setPaint(Color.blue);
        TextTitleTests.assertFalse((boolean)textTitle.equals(textTitle2));
        textTitle2.setPaint(Color.blue);
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
        textTitle.setBackgroundPaint(Color.blue);
        TextTitleTests.assertFalse((boolean)textTitle.equals(textTitle2));
        textTitle2.setBackgroundPaint(Color.blue);
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
    }

    public void testHashcode() {
        TextTitle textTitle = new TextTitle();
        TextTitle textTitle2 = new TextTitle();
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
        int n = textTitle.hashCode();
        int n2 = textTitle2.hashCode();
        TextTitleTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        TextTitle textTitle = new TextTitle();
        TextTitle textTitle2 = null;
        try {
            textTitle2 = (TextTitle)textTitle.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("TextTitleTests.testCloning: failed to clone.");
        }
        TextTitleTests.assertTrue((textTitle != textTitle2 ? 1 : 0) != 0);
        TextTitleTests.assertTrue((textTitle.getClass() == textTitle2.getClass() ? 1 : 0) != 0);
        TextTitleTests.assertTrue((boolean)textTitle.equals(textTitle2));
    }

    public void testSerialization() {
        TextTitle textTitle = new TextTitle("Test");
        TextTitle textTitle2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(textTitle);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            textTitle2 = (TextTitle)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TextTitleTests.assertEquals((Object)textTitle, textTitle2);
    }
}

