/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.title.DateTitle;

public class DateTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DateTitleTests.class);
    }

    public DateTitleTests(String string) {
        super(string);
    }

    public void testEquals() {
        DateTitle dateTitle = new DateTitle();
        DateTitle dateTitle2 = new DateTitle();
        DateTitleTests.assertEquals((Object)dateTitle, (Object)dateTitle2);
        dateTitle.setText("Test 1");
        DateTitleTests.assertFalse((boolean)dateTitle.equals(dateTitle2));
        dateTitle2.setText("Test 1");
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
        Font font = new Font("SansSerif", 0, 15);
        dateTitle.setFont(font);
        DateTitleTests.assertFalse((boolean)dateTitle.equals(dateTitle2));
        dateTitle2.setFont(font);
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
        dateTitle.setPaint(Color.blue);
        DateTitleTests.assertFalse((boolean)dateTitle.equals(dateTitle2));
        dateTitle2.setPaint(Color.blue);
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
        dateTitle.setBackgroundPaint(Color.blue);
        DateTitleTests.assertFalse((boolean)dateTitle.equals(dateTitle2));
        dateTitle2.setBackgroundPaint(Color.blue);
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
    }

    public void testHashcode() {
        DateTitle dateTitle = new DateTitle();
        DateTitle dateTitle2 = new DateTitle();
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
        int n = dateTitle.hashCode();
        int n2 = dateTitle2.hashCode();
        DateTitleTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        DateTitle dateTitle = new DateTitle();
        DateTitle dateTitle2 = null;
        try {
            dateTitle2 = (DateTitle)dateTitle.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("DateTitleTests.testCloning: failed to clone.");
        }
        DateTitleTests.assertTrue((dateTitle != dateTitle2 ? 1 : 0) != 0);
        DateTitleTests.assertTrue((dateTitle.getClass() == dateTitle2.getClass() ? 1 : 0) != 0);
        DateTitleTests.assertTrue((boolean)dateTitle.equals(dateTitle2));
    }

    public void testSerialization() {
        DateTitle dateTitle = new DateTitle();
        DateTitle dateTitle2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(dateTitle);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            dateTitle2 = (DateTitle)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DateTitleTests.assertEquals((Object)dateTitle, dateTitle2);
    }
}

