/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.ui.RectangleInsets;

public class CompositeTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CompositeTitleTests.class);
    }

    public CompositeTitleTests(String string) {
        super(string);
    }

    public void testEquals() {
        CompositeTitle compositeTitle = new CompositeTitle(new BlockContainer());
        CompositeTitle compositeTitle2 = new CompositeTitle(new BlockContainer());
        CompositeTitleTests.assertEquals((Object)compositeTitle, (Object)compositeTitle2);
        CompositeTitleTests.assertEquals((Object)compositeTitle2, (Object)compositeTitle);
        compositeTitle.setMargin(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertFalse((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle2.setMargin(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle.setBorder(new BlockBorder(Color.red));
        CompositeTitleTests.assertFalse((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle2.setBorder(new BlockBorder(Color.red));
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle.setPadding(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertFalse((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle2.setPadding(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertFalse((boolean)compositeTitle.equals(compositeTitle2));
        compositeTitle2.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
    }

    public void testHashcode() {
        CompositeTitle compositeTitle = new CompositeTitle(new BlockContainer());
        compositeTitle.getContainer().add(new TextTitle("T1"));
        CompositeTitle compositeTitle2 = new CompositeTitle(new BlockContainer());
        compositeTitle2.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
        int n = compositeTitle.hashCode();
        int n2 = compositeTitle2.hashCode();
        CompositeTitleTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        CompositeTitle compositeTitle = new CompositeTitle(new BlockContainer());
        compositeTitle.getContainer().add(new TextTitle("T1"));
        CompositeTitle compositeTitle2 = null;
        try {
            compositeTitle2 = (CompositeTitle)compositeTitle.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CompositeTitleTests.fail((String)cloneNotSupportedException.toString());
        }
        CompositeTitleTests.assertTrue((compositeTitle != compositeTitle2 ? 1 : 0) != 0);
        CompositeTitleTests.assertTrue((compositeTitle.getClass() == compositeTitle2.getClass() ? 1 : 0) != 0);
        CompositeTitleTests.assertTrue((boolean)compositeTitle.equals(compositeTitle2));
    }

    public void testSerialization() {
        CompositeTitle compositeTitle = new CompositeTitle(new BlockContainer());
        compositeTitle.getContainer().add(new TextTitle("T1"));
        CompositeTitle compositeTitle2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(compositeTitle);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            compositeTitle2 = (CompositeTitle)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CompositeTitleTests.assertEquals((Object)compositeTitle, compositeTitle2);
    }
}

