/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jfree.chart.servlet.ChartDeleter;
import org.jfree.chart.servlet.ServletUtilities;

public class DisplayChart
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = httpServletRequest.getParameter("filename");
        if (string == null) {
            throw new ServletException("Parameter 'filename' must be supplied");
        }
        string = ServletUtilities.searchReplace(string, "..", "");
        File file = new File(System.getProperty("java.io.tmpdir"), string);
        if (!file.exists()) {
            throw new ServletException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        boolean bl = false;
        ChartDeleter chartDeleter = (ChartDeleter)httpSession.getAttribute("JFreeChart_Deleter");
        if (chartDeleter != null) {
            bl = chartDeleter.isChartAvailable(string);
        }
        boolean bl2 = false;
        if (string.length() >= 6 && string.substring(0, 6).equals("public")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (string.startsWith(ServletUtilities.getTempOneTimeFilePrefix())) {
            bl3 = true;
        }
        if (bl || bl2 || bl3) {
            ServletUtilities.sendTempFile(file, httpServletResponse);
            if (bl3) {
                file.delete();
            }
        } else {
            throw new ServletException("Chart image not found");
        }
    }
}

