/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class XYLineAndShapeRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYLineAndShapeRendererTests.class);
    }

    public XYLineAndShapeRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = new XYLineAndShapeRenderer();
        XYLineAndShapeRendererTests.assertEquals((Object)xYLineAndShapeRenderer, (Object)xYLineAndShapeRenderer2);
        XYLineAndShapeRendererTests.assertEquals((Object)xYLineAndShapeRenderer2, (Object)xYLineAndShapeRenderer);
        xYLineAndShapeRenderer.setLinesVisible(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setLinesVisible(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setSeriesLinesVisible(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setSeriesLinesVisible(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setDefaultLinesVisible(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setDefaultLinesVisible(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setShapesVisible(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setShapesVisible(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setSeriesShapesVisible(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setSeriesShapesVisible(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setDefaultShapesVisible(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setDefaultShapesVisible(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setShapesFilled(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setShapesFilled(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setSeriesShapesFilled(3, true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setSeriesShapesFilled(3, true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setDefaultShapesFilled(false);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setDefaultShapesFilled(false);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setDrawOutlines(!xYLineAndShapeRenderer.getDrawOutlines());
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setDrawOutlines(xYLineAndShapeRenderer.getDrawOutlines());
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer.setUseOutlinePaint(true);
        XYLineAndShapeRendererTests.assertFalse((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        xYLineAndShapeRenderer2.setUseOutlinePaint(true);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
    }

    public void testHashcode() {
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = new XYLineAndShapeRenderer();
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
        int n = xYLineAndShapeRenderer.hashCode();
        int n2 = xYLineAndShapeRenderer2.hashCode();
        XYLineAndShapeRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = null;
        try {
            xYLineAndShapeRenderer2 = (XYLineAndShapeRenderer)xYLineAndShapeRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYLineAndShapeRendererTests.assertTrue((xYLineAndShapeRenderer != xYLineAndShapeRenderer2 ? 1 : 0) != 0);
        XYLineAndShapeRendererTests.assertTrue((xYLineAndShapeRenderer.getClass() == xYLineAndShapeRenderer2.getClass() ? 1 : 0) != 0);
        XYLineAndShapeRendererTests.assertTrue((boolean)xYLineAndShapeRenderer.equals(xYLineAndShapeRenderer2));
    }

    public void testSerialization() {
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYLineAndShapeRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYLineAndShapeRenderer2 = (XYLineAndShapeRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYLineAndShapeRendererTests.assertEquals((Object)xYLineAndShapeRenderer, xYLineAndShapeRenderer2);
    }

    public void testFindDomainBounds() {
        XYSeriesCollection xYSeriesCollection = RendererXYPackageTests.createTestXYSeriesCollection();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Test Chart", "X", "Y", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        Range range = numberAxis.getRange();
        XYLineAndShapeRendererTests.assertFalse((boolean)range.contains(0.9));
        XYLineAndShapeRendererTests.assertTrue((boolean)range.contains(1.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)range.contains(2.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)range.contains(2.1));
    }

    public void testFindRangeBounds() {
        TableXYDataset tableXYDataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Test Chart", "X", "Y", tableXYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        Range range = numberAxis.getRange();
        XYLineAndShapeRendererTests.assertFalse((boolean)range.contains(1.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)range.contains(2.0));
        XYLineAndShapeRendererTests.assertTrue((boolean)range.contains(5.0));
        XYLineAndShapeRendererTests.assertFalse((boolean)range.contains(6.0));
    }
}

