/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;

public class XYDifferenceRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDifferenceRendererTests.class);
    }

    public XYDifferenceRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYDifferenceRenderer xYDifferenceRenderer = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer xYDifferenceRenderer2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRendererTests.assertEquals((Object)xYDifferenceRenderer, (Object)xYDifferenceRenderer2);
        xYDifferenceRenderer = new XYDifferenceRenderer(Color.green, Color.blue, false);
        XYDifferenceRendererTests.assertFalse((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer2 = new XYDifferenceRenderer(Color.green, Color.blue, false);
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer = new XYDifferenceRenderer(Color.green, Color.yellow, false);
        XYDifferenceRendererTests.assertFalse((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer2 = new XYDifferenceRenderer(Color.green, Color.yellow, false);
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer = new XYDifferenceRenderer(Color.green, Color.yellow, true);
        XYDifferenceRendererTests.assertFalse((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer2 = new XYDifferenceRenderer(Color.green, Color.yellow, true);
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYDifferenceRendererTests.assertFalse((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        xYDifferenceRenderer2.setLegendLine(new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        XYDifferenceRendererTests.assertFalse((boolean)xYDifferenceRenderer.equals(null));
    }

    public void testHashcode() {
        XYDifferenceRenderer xYDifferenceRenderer = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer xYDifferenceRenderer2 = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
        int n = xYDifferenceRenderer.hashCode();
        int n2 = xYDifferenceRenderer2.hashCode();
        XYDifferenceRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYDifferenceRenderer xYDifferenceRenderer = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer xYDifferenceRenderer2 = null;
        try {
            xYDifferenceRenderer2 = (XYDifferenceRenderer)xYDifferenceRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYDifferenceRendererTests.assertTrue((xYDifferenceRenderer != xYDifferenceRenderer2 ? 1 : 0) != 0);
        XYDifferenceRendererTests.assertTrue((xYDifferenceRenderer.getClass() == xYDifferenceRenderer2.getClass() ? 1 : 0) != 0);
        XYDifferenceRendererTests.assertTrue((boolean)xYDifferenceRenderer.equals(xYDifferenceRenderer2));
    }

    public void testSerialization() {
        XYDifferenceRenderer xYDifferenceRenderer = new XYDifferenceRenderer(Color.red, Color.blue, false);
        XYDifferenceRenderer xYDifferenceRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYDifferenceRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYDifferenceRenderer2 = (XYDifferenceRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYDifferenceRendererTests.assertEquals((Object)xYDifferenceRenderer, xYDifferenceRenderer2);
    }
}

