/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;

public class XYBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYBarRendererTests.class);
    }

    public XYBarRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        XYBarRenderer xYBarRenderer2 = new XYBarRenderer();
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer2.equals(xYBarRenderer));
        xYBarRenderer.setBase(1.0);
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setBase(1.0);
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer.setUseYInterval(!xYBarRenderer.getUseYInterval());
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setUseYInterval(!xYBarRenderer2.getUseYInterval());
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer.setMargin(0.1);
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setMargin(0.1);
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer.setDrawBarOutline(!xYBarRenderer.isDrawBarOutline());
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setDrawBarOutline(!xYBarRenderer2.isDrawBarOutline());
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer.setLegendBar(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYBarRendererTests.assertFalse((boolean)xYBarRenderer.equals(xYBarRenderer2));
        xYBarRenderer2.setLegendBar(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
    }

    public void testHashcode() {
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        XYBarRenderer xYBarRenderer2 = new XYBarRenderer();
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
        int n = xYBarRenderer.hashCode();
        int n2 = xYBarRenderer2.hashCode();
        XYBarRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        XYBarRenderer xYBarRenderer2 = null;
        try {
            xYBarRenderer2 = (XYBarRenderer)xYBarRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYBarRendererTests.assertTrue((xYBarRenderer != xYBarRenderer2 ? 1 : 0) != 0);
        XYBarRendererTests.assertTrue((xYBarRenderer.getClass() == xYBarRenderer2.getClass() ? 1 : 0) != 0);
        XYBarRendererTests.assertTrue((boolean)xYBarRenderer.equals(xYBarRenderer2));
    }

    public void testSerialization() {
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        XYBarRenderer xYBarRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYBarRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYBarRenderer2 = (XYBarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYBarRendererTests.assertEquals((Object)xYBarRenderer, xYBarRenderer2);
    }

    public void testFindDomainBounds() {
        XYSeriesCollection xYSeriesCollection = RendererXYPackageTests.createTestXYSeriesCollection();
        JFreeChart jFreeChart = ChartFactory.createXYBarChart("Test Chart", "X", false, "Y", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        Range range = numberAxis.getRange();
        XYBarRendererTests.assertFalse((boolean)range.contains(0.3));
        XYBarRendererTests.assertTrue((boolean)range.contains(0.5));
        XYBarRendererTests.assertTrue((boolean)range.contains(2.5));
        XYBarRendererTests.assertFalse((boolean)range.contains(2.8));
    }
}

