/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYAreaRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYAreaRendererTests.class);
    }

    public StackedXYAreaRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        StackedXYAreaRenderer stackedXYAreaRenderer = new StackedXYAreaRenderer();
        StackedXYAreaRenderer stackedXYAreaRenderer2 = new StackedXYAreaRenderer();
        StackedXYAreaRendererTests.assertEquals((Object)stackedXYAreaRenderer, (Object)stackedXYAreaRenderer2);
        StackedXYAreaRendererTests.assertEquals((Object)stackedXYAreaRenderer2, (Object)stackedXYAreaRenderer);
        stackedXYAreaRenderer.setShapePaint(Color.yellow);
        StackedXYAreaRendererTests.assertFalse((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
        stackedXYAreaRenderer2.setShapePaint(Color.yellow);
        StackedXYAreaRendererTests.assertTrue((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
        BasicStroke basicStroke = new BasicStroke(1.23f);
        stackedXYAreaRenderer.setShapeStroke(basicStroke);
        StackedXYAreaRendererTests.assertFalse((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
        stackedXYAreaRenderer2.setShapeStroke(basicStroke);
        StackedXYAreaRendererTests.assertTrue((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
    }

    public void testHashcode() {
        StackedXYAreaRenderer stackedXYAreaRenderer = new StackedXYAreaRenderer();
        StackedXYAreaRenderer stackedXYAreaRenderer2 = new StackedXYAreaRenderer();
        StackedXYAreaRendererTests.assertTrue((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
        int n = stackedXYAreaRenderer.hashCode();
        int n2 = stackedXYAreaRenderer2.hashCode();
        StackedXYAreaRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        StackedXYAreaRenderer stackedXYAreaRenderer = new StackedXYAreaRenderer();
        StackedXYAreaRenderer stackedXYAreaRenderer2 = null;
        try {
            stackedXYAreaRenderer2 = (StackedXYAreaRenderer)stackedXYAreaRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StackedXYAreaRendererTests.assertTrue((stackedXYAreaRenderer != stackedXYAreaRenderer2 ? 1 : 0) != 0);
        StackedXYAreaRendererTests.assertTrue((stackedXYAreaRenderer.getClass() == stackedXYAreaRenderer2.getClass() ? 1 : 0) != 0);
        StackedXYAreaRendererTests.assertTrue((boolean)stackedXYAreaRenderer.equals(stackedXYAreaRenderer2));
    }

    public void testSerialization() {
        StackedXYAreaRenderer stackedXYAreaRenderer = new StackedXYAreaRenderer();
        StackedXYAreaRenderer stackedXYAreaRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stackedXYAreaRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            stackedXYAreaRenderer2 = (StackedXYAreaRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StackedXYAreaRendererTests.assertEquals((Object)stackedXYAreaRenderer, stackedXYAreaRenderer2);
    }

    public void testFindRangeBounds() {
        TableXYDataset tableXYDataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", tableXYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        Range range = numberAxis.getRange();
        StackedXYAreaRendererTests.assertTrue((boolean)range.contains(6.0));
        StackedXYAreaRendererTests.assertTrue((boolean)range.contains(8.0));
    }
}

