/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYAreaRenderer2Tests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYAreaRenderer2Tests.class);
    }

    public StackedXYAreaRenderer2Tests(String string) {
        super(string);
    }

    public void testEquals() {
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 stackedXYAreaRenderer22 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2Tests.assertEquals((Object)stackedXYAreaRenderer2, (Object)stackedXYAreaRenderer22);
        StackedXYAreaRenderer2Tests.assertEquals((Object)stackedXYAreaRenderer22, (Object)stackedXYAreaRenderer2);
    }

    public void testHashcode() {
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 stackedXYAreaRenderer22 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2Tests.assertTrue((boolean)stackedXYAreaRenderer2.equals(stackedXYAreaRenderer22));
        int n = stackedXYAreaRenderer2.hashCode();
        int n2 = stackedXYAreaRenderer22.hashCode();
        StackedXYAreaRenderer2Tests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 stackedXYAreaRenderer22 = null;
        try {
            stackedXYAreaRenderer22 = (StackedXYAreaRenderer2)stackedXYAreaRenderer2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StackedXYAreaRenderer2Tests.assertTrue((stackedXYAreaRenderer2 != stackedXYAreaRenderer22 ? 1 : 0) != 0);
        StackedXYAreaRenderer2Tests.assertTrue((stackedXYAreaRenderer2.getClass() == stackedXYAreaRenderer22.getClass() ? 1 : 0) != 0);
        StackedXYAreaRenderer2Tests.assertTrue((boolean)stackedXYAreaRenderer2.equals(stackedXYAreaRenderer22));
    }

    public void testSerialization() {
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2();
        StackedXYAreaRenderer2 stackedXYAreaRenderer22 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stackedXYAreaRenderer2);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            stackedXYAreaRenderer22 = (StackedXYAreaRenderer2)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StackedXYAreaRenderer2Tests.assertEquals((Object)stackedXYAreaRenderer2, stackedXYAreaRenderer22);
    }

    public void testFindRangeBounds() {
        TableXYDataset tableXYDataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", tableXYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setRenderer(new StackedXYAreaRenderer2());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        Range range = numberAxis.getRange();
        StackedXYAreaRenderer2Tests.assertTrue((boolean)range.contains(6.0));
        StackedXYAreaRenderer2Tests.assertTrue((boolean)range.contains(8.0));
    }
}

