/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AbstractXYItemRendererTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(AbstractXYItemRendererTests.class);
    }

    public AbstractXYItemRendererTests(String string) {
        super(string);
    }

    private XYDataset createDataset1() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return xYSeriesCollection;
    }

    public void testFindDomainBounds() {
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYDataset xYDataset = this.createDataset1();
        Range range = standardXYItemRenderer.findDomainBounds(xYDataset);
        AbstractXYItemRendererTests.assertEquals((double)1.0, (double)range.getLowerBound(), (double)1.0E-10);
        AbstractXYItemRendererTests.assertEquals((double)3.0, (double)range.getUpperBound(), (double)1.0E-10);
        AbstractXYItemRendererTests.assertTrue((standardXYItemRenderer.findDomainBounds(null) == null ? 1 : 0) != 0);
    }

    public void testFindRangeBounds() {
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        AbstractXYItemRendererTests.assertTrue((standardXYItemRenderer.findRangeBounds(null) == null ? 1 : 0) != 0);
    }
}

