/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYStepRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8918141928884796108L;

    public XYStepRenderer() {
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (n2 > 0) {
            double d5 = xYDataset.getXValue(n, n2 - 1);
            double d6 = xYDataset.getYValue(n, n2 - 1);
            if (!Double.isNaN(d6)) {
                double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
                double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
                Line2D line2D = xYItemRendererState.workingLine;
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    if (d8 == d4) {
                        line2D.setLine(d8, d7, d4, d3);
                        graphics2D.draw(line2D);
                    } else {
                        line2D.setLine(d8, d7, d4, d7);
                        graphics2D.draw(line2D);
                        line2D.setLine(d4, d7, d4, d3);
                        graphics2D.draw(line2D);
                    }
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    if (d8 == d4) {
                        line2D.setLine(d7, d8, d3, d4);
                        graphics2D.draw(line2D);
                    } else {
                        line2D.setLine(d7, d8, d3, d8);
                        graphics2D.draw(line2D);
                        line2D.setLine(d3, d8, d3, d4);
                        graphics2D.draw(line2D);
                    }
                }
            }
        }
        this.updateCrosshairValues(crosshairState, d, d2, d3, d4, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            Rectangle2D.Double double_;
            Rectangle2D.Double double_2 = double_ = plotOrientation == PlotOrientation.VERTICAL ? new Rectangle2D.Double(d3 - 2.0, d4 - 2.0, 4.0, 4.0) : new Rectangle2D.Double(d4 - 2.0, d3 - 2.0, 4.0, 4.0);
            if (double_ != null) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
                entityCollection.add(xYItemEntity);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

