/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYDotRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2764344339073566425L;

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (!Double.isNaN(d2)) {
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
            double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            graphics2D.setPaint(this.getItemPaint(n, n2));
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.drawRect((int)d4, (int)d3, 1, 1);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                graphics2D.drawRect((int)d3, (int)d4, 1, 1);
            }
            this.updateCrosshairValues(crosshairState, d, d2, d3, d4, plotOrientation);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

