/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4481971353973876747L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;
    private transient Shape legendArea;

    public XYAreaRenderer() {
        this(4);
    }

    public XYAreaRenderer(int n) {
        this(n, null, null);
    }

    public XYAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -4.0f);
        generalPath.lineTo(3.0f, -2.0f);
        generalPath.lineTo(4.0f, 4.0f);
        generalPath.lineTo(-4.0f, 4.0f);
        generalPath.lineTo(-3.0f, -2.0f);
        generalPath.closePath();
        this.legendArea = generalPath;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public Shape getLegendArea() {
        return this.legendArea;
    }

    public void setLegendArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.legendArea = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYAreaRendererState xYAreaRendererState = new XYAreaRendererState(plotRenderingInfo);
        return xYAreaRendererState;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.getSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.legendArea, paint);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        XYAreaRendererState xYAreaRendererState = (XYAreaRendererState)xYItemRendererState;
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        double d5 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d6 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d6)) {
            d6 = 0.0;
        }
        double d7 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getDomainAxisEdge());
        double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
        double d9 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d10 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d10)) {
            d10 = 0.0;
        }
        double d11 = valueAxis.valueToJava2D(d9, rectangle2D, xYPlot.getDomainAxisEdge());
        double d12 = valueAxis2.valueToJava2D(d10, rectangle2D, xYPlot.getRangeAxisEdge());
        double d13 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        Polygon polygon = null;
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            polygon = new Polygon();
            polygon.addPoint((int)d13, (int)((d7 + d3) / 2.0));
            polygon.addPoint((int)((d8 + d4) / 2.0), (int)((d7 + d3) / 2.0));
            polygon.addPoint((int)d4, (int)d3);
            polygon.addPoint((int)((d4 + d12) / 2.0), (int)((d3 + d11) / 2.0));
            polygon.addPoint((int)d13, (int)((d3 + d11) / 2.0));
        } else {
            polygon = new Polygon();
            polygon.addPoint((int)((d7 + d3) / 2.0), (int)d13);
            polygon.addPoint((int)((d7 + d3) / 2.0), (int)((d8 + d4) / 2.0));
            polygon.addPoint((int)d3, (int)d4);
            polygon.addPoint((int)((d3 + d11) / 2.0), (int)((d4 + d12) / 2.0));
            polygon.addPoint((int)((d3 + d11) / 2.0), (int)d13);
        }
        if (n2 == 0) {
            xYAreaRendererState.area = new Polygon();
            double d14 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYAreaRendererState.area.addPoint((int)d3, (int)d14);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYAreaRendererState.area.addPoint((int)d14, (int)d3);
            }
        }
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            xYAreaRendererState.area.addPoint((int)d3, (int)d4);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            xYAreaRendererState.area.addPoint((int)d4, (int)d3);
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Shape shape = null;
        if (this.getPlotShapes()) {
            shape = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d3, d4);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d4, d3);
            }
            graphics2D.draw(shape);
        }
        if (this.getPlotLines() && n2 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYAreaRendererState.line.setLine(d7, d8, d3, d4);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYAreaRendererState.line.setLine(d8, d7, d4, d3);
            }
            graphics2D.draw(xYAreaRendererState.line);
        }
        if (this.getPlotArea() && n2 > 0 && n2 == n4 - 1) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                xYAreaRendererState.area.addPoint((int)d3, (int)d13);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                xYAreaRendererState.area.addPoint((int)d13, (int)d3);
            }
            graphics2D.fill(xYAreaRendererState.area);
            if (this.isOutline()) {
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(xYAreaRendererState.area);
            }
        }
        this.updateCrosshairValues(crosshairState, d, d2, d3, d4, plotOrientation);
        if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && polygon != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(polygon, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYAreaRenderer)) {
            return false;
        }
        XYAreaRenderer xYAreaRenderer = (XYAreaRenderer)object;
        if (this.plotArea != xYAreaRenderer.plotArea) {
            return false;
        }
        if (this.plotLines != xYAreaRenderer.plotLines) {
            return false;
        }
        if (this.plotShapes != xYAreaRenderer.plotShapes) {
            return false;
        }
        if (this.showOutline != xYAreaRenderer.showOutline) {
            return false;
        }
        return ShapeUtilities.equal(this.legendArea, xYAreaRenderer.legendArea);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendArea = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendArea, objectOutputStream);
    }

    static class XYAreaRendererState
    extends XYItemRendererState {
        public Polygon area = new Polygon();
        public Line2D line = new Line2D.Double();

        public XYAreaRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }
}

