/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StackedXYBarRenderer
extends XYBarRenderer
implements Serializable {
    private static final long serialVersionUID = -7049101055533436444L;

    public StackedXYBarRenderer() {
    }

    public StackedXYBarRenderer(double d) {
        super(d);
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new XYBarRenderer.XYBarRendererState(this, plotRenderingInfo);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)xYDataset);
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        double d;
        double d2;
        if (!(xYDataset instanceof IntervalXYDataset) || !(xYDataset instanceof TableXYDataset)) {
            String string = "dataset (type " + xYDataset.getClass().getName() + ") has wrong type:";
            boolean bl = false;
            if (!IntervalXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                string = string + " it is no IntervalXYDataset";
                bl = true;
            }
            if (!TableXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                if (bl) {
                    string = string + " and";
                }
                string = string + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(string);
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        double d3 = intervalXYDataset.getYValue(n, n2);
        if (Double.isNaN(d3)) {
            return;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6 = xYDataset.getYValue(i, n2);
            if (Double.isNaN(d6)) continue;
            if (d6 > 0.0) {
                d4 += d6;
                continue;
            }
            d5 += d6;
        }
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d2 = valueAxis2.valueToJava2D(d4, rectangle2D, rectangleEdge);
            d = valueAxis2.valueToJava2D(d4 + d3, rectangle2D, rectangleEdge);
        } else {
            d2 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
            d = valueAxis2.valueToJava2D(d5 + d3, rectangle2D, rectangleEdge);
        }
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d7 = intervalXYDataset.getStartXValue(n, n2);
        if (Double.isNaN(d7)) {
            return;
        }
        double d8 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge2);
        double d9 = intervalXYDataset.getEndXValue(n, n2);
        if (Double.isNaN(d9)) {
            return;
        }
        double d10 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge2);
        double d11 = Math.max(1.0, Math.abs(d10 - d8));
        double d12 = Math.abs(d - d2);
        if (this.getMargin() > 0.0) {
            double d13 = d11 * this.getMargin();
            d11 -= d13;
            d8 += d13 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d2, d), d10, d12, d11);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d8, Math.min(d2, d), d11, d12);
        }
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d10 - d8) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }
}

