/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 50390395841817121L;
    public static final int WIDTHMETHOD_AVERAGE = 0;
    public static final int WIDTHMETHOD_SMALLEST = 1;
    public static final int WIDTHMETHOD_INTERVALDATA = 2;
    private int autoWidthMethod = 0;
    private double autoWidthFactor = 0.6428571428571429;
    private double autoWidthGap = 0.0;
    private double candleWidth;
    private double maxCandleWidthInMilliseconds = 7.2E7;
    private double maxCandleWidth;
    private transient Paint upPaint;
    private transient Paint downPaint;
    private boolean drawVolume;
    private transient double maxVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true, new HighLowItemLabelGenerator());
    }

    public CandlestickRenderer(double d, boolean bl, XYToolTipGenerator xYToolTipGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            this.candleWidth = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getMaxCandleWidthInMilliseconds() {
        return this.maxCandleWidthInMilliseconds;
    }

    public void setMaxCandleWidthInMilliseconds(double d) {
        this.maxCandleWidthInMilliseconds = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getAutoWidthMethod() {
        return this.autoWidthMethod;
    }

    public void setAutoWidthMethod(int n) {
        if (this.autoWidthMethod != n) {
            this.autoWidthMethod = n;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getAutoWidthFactor() {
        return this.autoWidthFactor;
    }

    public void setAutoWidthFactor(double d) {
        if (this.autoWidthFactor != d) {
            this.autoWidthFactor = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getAutoWidthGap() {
        return this.autoWidthGap;
    }

    public void setAutoWidthGap(double d) {
        if (this.autoWidthGap != d) {
            this.autoWidthGap = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        this.upPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        this.downPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        double d = valueAxis.getLowerBound();
        double d2 = d + this.maxCandleWidthInMilliseconds;
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        this.maxCandleWidth = Math.abs(d4 - d3);
        if (this.drawVolume) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            this.maxVolume = 0.0;
            for (int i = 0; i < oHLCDataset.getSeriesCount(); ++i) {
                for (int j = 0; j < oHLCDataset.getItemCount(i); ++j) {
                    double d5 = oHLCDataset.getVolumeValue(i, j);
                    if (!(d5 > this.maxVolume)) continue;
                    this.maxVolume = d5;
                }
            }
        }
        return new XYItemRendererState(plotRenderingInfo);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        double d;
        double d2;
        double d3;
        int n4;
        double d4;
        double d5;
        boolean bl;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl = true;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            bl = false;
        } else {
            return;
        }
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
        Number number = oHLCDataset.getX(n, n2);
        Number number2 = oHLCDataset.getHigh(n, n2);
        Number number3 = oHLCDataset.getLow(n, n2);
        Number number4 = oHLCDataset.getOpen(n, n2);
        Number number5 = oHLCDataset.getClose(n, n2);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d6 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d7 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        double d8 = valueAxis2.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge2);
        double d9 = valueAxis2.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge2);
        double d10 = valueAxis2.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge2);
        if (this.candleWidth > 0.0) {
            d5 = this.candleWidth;
            d4 = this.candleWidth;
        } else {
            double d11 = 0.0;
            switch (this.autoWidthMethod) {
                case 0: {
                    n4 = oHLCDataset.getItemCount(n);
                    if (bl) {
                        d11 = rectangle2D.getHeight() / (double)n4;
                        break;
                    }
                    d11 = rectangle2D.getWidth() / (double)n4;
                    break;
                }
                case 1: {
                    n4 = oHLCDataset.getItemCount(n);
                    d3 = -1.0;
                    d11 = rectangle2D.getWidth();
                    for (int i = 0; i < n4; ++i) {
                        d2 = valueAxis.valueToJava2D(oHLCDataset.getXValue(n, i), rectangle2D, rectangleEdge);
                        if (d3 != -1.0) {
                            d11 = Math.min(d11, Math.abs(d2 - d3));
                        }
                        d3 = d2;
                    }
                    break;
                }
                case 2: {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d2 = valueAxis.valueToJava2D(intervalXYDataset.getStartXValue(n, n2), rectangle2D, xYPlot.getDomainAxisEdge());
                    d = valueAxis.valueToJava2D(intervalXYDataset.getEndXValue(n, n2), rectangle2D, xYPlot.getDomainAxisEdge());
                    d11 = Math.abs(d - d2);
                }
            }
            d11 -= 2.0 * this.autoWidthGap;
            d11 *= this.autoWidthFactor;
            d11 = Math.min(d11, this.maxCandleWidth);
            d5 = Math.max(Math.min(1.0, this.maxCandleWidth), d11);
            d4 = Math.max(Math.min(3.0, this.maxCandleWidth), d11);
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            double d12;
            double d13;
            n4 = (int)oHLCDataset.getVolumeValue(n, n2);
            d3 = (double)n4 / this.maxVolume;
            if (bl) {
                d13 = rectangle2D.getMinX();
                d12 = rectangle2D.getMaxX();
            } else {
                d13 = rectangle2D.getMinY();
                d12 = rectangle2D.getMaxY();
            }
            double d14 = d3 * (d12 - d13);
            graphics2D.setPaint(Color.gray);
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            if (bl) {
                graphics2D.fill(new Rectangle2D.Double(d13, d6 - d5 / 2.0, d14, d5));
            } else {
                graphics2D.fill(new Rectangle2D.Double(d6 - d5 / 2.0, d12 - d14, d5, d14));
            }
            graphics2D.setComposite((Composite)object);
        }
        graphics2D.setPaint(paint);
        double d15 = Math.max(d9, d10);
        double d16 = Math.min(d9, d10);
        d2 = Math.max(number4.doubleValue(), number5.doubleValue());
        d = Math.min(number4.doubleValue(), number5.doubleValue());
        if (number2.doubleValue() > d2) {
            if (bl) {
                graphics2D.draw(new Line2D.Double(d7, d6, d15, d6));
            } else {
                graphics2D.draw(new Line2D.Double(d6, d7, d6, d15));
            }
        }
        if (number3.doubleValue() < d) {
            if (bl) {
                graphics2D.draw(new Line2D.Double(d8, d6, d16, d6));
            } else {
                graphics2D.draw(new Line2D.Double(d6, d8, d6, d16));
            }
        }
        Rectangle2D.Double double_ = null;
        double_ = bl ? new Rectangle2D.Double(d16, d6 - d4 / 2.0, d15 - d16, d4) : new Rectangle2D.Double(d6 - d4 / 2.0, d16, d4, d15 - d16);
        if (number5.doubleValue() > number4.doubleValue()) {
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_);
            }
        } else {
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        if (entityCollection != null) {
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, (String)object, string);
            entityCollection.add(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CandlestickRenderer) {
            CandlestickRenderer candlestickRenderer = (CandlestickRenderer)object;
            boolean bl = super.equals(object);
            bl = bl && this.candleWidth == candlestickRenderer.getCandleWidth();
            bl = bl && this.upPaint.equals(candlestickRenderer.getUpPaint());
            bl = bl && this.downPaint.equals(candlestickRenderer.getDownPaint());
            bl = bl && this.drawVolume == candlestickRenderer.drawVolume;
            return bl;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.upPaint, objectOutputStream);
        SerialUtilities.writePaint(this.downPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upPaint = SerialUtilities.readPaint(objectInputStream);
        this.downPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

