/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.junit.RendererChangeDetector;
import org.jfree.ui.TextAnchor;

public class AbstractRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(AbstractRendererTests.class);
    }

    public AbstractRendererTests(String string) {
        super(string);
    }

    public void testSetSeriesVisible() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setSeriesVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)barRenderer.getItemVisible(0, 0));
    }

    public void testSetPaint() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setPaint(Color.orange);
        AbstractRendererTests.assertEquals((Object)Color.orange, (Object)barRenderer.getItemPaint(0, 0));
    }

    public void testSetOutlinePaint() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setOutlinePaint(Color.orange);
        AbstractRendererTests.assertEquals((Object)Color.orange, (Object)barRenderer.getItemOutlinePaint(0, 0));
    }

    public void testSetStroke() {
        BarRenderer barRenderer = new BarRenderer();
        BasicStroke basicStroke = new BasicStroke(10.0f);
        barRenderer.setStroke(basicStroke);
        AbstractRendererTests.assertEquals((Object)basicStroke, (Object)barRenderer.getItemStroke(0, 0));
    }

    public void testSetOutlineStroke() {
        BarRenderer barRenderer = new BarRenderer();
        BasicStroke basicStroke = new BasicStroke(10.0f);
        barRenderer.setOutlineStroke(basicStroke);
        AbstractRendererTests.assertEquals((Object)basicStroke, (Object)barRenderer.getItemOutlineStroke(0, 0));
    }

    public void testSetShape() {
        BarRenderer barRenderer = new BarRenderer();
        Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        barRenderer.setShape(double_);
        AbstractRendererTests.assertEquals((Object)double_, (Object)barRenderer.getItemShape(0, 0));
    }

    public void testSetItemLabelsVisible() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelsVisible(true);
        AbstractRendererTests.assertTrue((boolean)barRenderer.isItemLabelVisible(0, 0));
    }

    public void testSetItemLabelFont() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelFont(new Font("SansSerif", 0, 33));
        AbstractRendererTests.assertEquals((Object)new Font("SansSerif", 0, 33), (Object)barRenderer.getItemLabelFont(0, 0));
    }

    public void testSetItemLabelPaint() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelPaint(Color.green);
        AbstractRendererTests.assertEquals((Object)Color.green, (Object)barRenderer.getItemLabelPaint(0, 0));
    }

    public void testSetPositiveItemLabelPosition() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT));
        AbstractRendererTests.assertEquals((Object)new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT), (Object)barRenderer.getPositiveItemLabelPosition(0, 0));
    }

    public void testSetNegativeItemLabelPosition() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT));
        AbstractRendererTests.assertEquals((Object)new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.BASELINE_LEFT), (Object)barRenderer.getNegativeItemLabelPosition(0, 0));
    }

    public void testEventNotification() {
        RendererChangeDetector rendererChangeDetector = new RendererChangeDetector();
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.addChangeListener(rendererChangeDetector);
        rendererChangeDetector.setNotified(false);
        barRenderer.setPaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesPaint(0, Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBasePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setOutlinePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesOutlinePaint(0, Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseOutlinePaint(Color.red);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesStroke(0, new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setOutlineStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesOutlineStroke(0, new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseOutlineStroke(new BasicStroke(1.0f));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setShape(new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesShape(0, new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseShape(new Rectangle2D.Float());
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setItemLabelsVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesItemLabelsVisible(0, Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseItemLabelsVisible(Boolean.TRUE);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setItemLabelFont(new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesItemLabelFont(0, new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseItemLabelFont(new Font("Serif", 0, 12));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setItemLabelPaint(Color.blue);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesItemLabelPaint(0, Color.blue);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseItemLabelPaint(Color.blue);
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesPositiveItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setSeriesNegativeItemLabelPosition(0, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
        rendererChangeDetector.setNotified(false);
        barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        AbstractRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
    }

    public void testSerialization() {
        BarRenderer barRenderer = new BarRenderer();
        AbstractRenderer abstractRenderer = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(barRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            abstractRenderer = (BarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        AbstractRendererTests.assertEquals((Object)barRenderer, abstractRenderer);
        try {
            abstractRenderer.notifyListeners(new RendererChangeEvent(abstractRenderer));
        }
        catch (NullPointerException nullPointerException) {
            AbstractRendererTests.assertTrue((boolean)false);
        }
    }
}

