/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;

public class WaterfallBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(WaterfallBarRendererTests.class);
    }

    public WaterfallBarRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        WaterfallBarRenderer waterfallBarRenderer2 = new WaterfallBarRenderer();
        WaterfallBarRendererTests.assertEquals((Object)waterfallBarRenderer, (Object)waterfallBarRenderer2);
        waterfallBarRenderer.setFirstBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer2.setFirstBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer.setLastBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer2.setLastBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer.setPositiveBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer2.setPositiveBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer.setNegativeBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertFalse((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer2.setNegativeBarPaint(Color.cyan);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
    }

    public void testHashcode() {
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        WaterfallBarRenderer waterfallBarRenderer2 = new WaterfallBarRenderer();
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        int n = waterfallBarRenderer.hashCode();
        int n2 = waterfallBarRenderer2.hashCode();
        WaterfallBarRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        WaterfallBarRenderer waterfallBarRenderer2 = null;
        try {
            waterfallBarRenderer2 = (WaterfallBarRenderer)waterfallBarRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        WaterfallBarRendererTests.assertTrue((waterfallBarRenderer != waterfallBarRenderer2 ? 1 : 0) != 0);
        WaterfallBarRendererTests.assertTrue((waterfallBarRenderer.getClass() == waterfallBarRenderer2.getClass() ? 1 : 0) != 0);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer.setFirstBarPaint(Color.yellow);
        WaterfallBarRendererTests.assertFalse((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
        waterfallBarRenderer2.setFirstBarPaint(Color.yellow);
        WaterfallBarRendererTests.assertTrue((boolean)waterfallBarRenderer.equals(waterfallBarRenderer2));
    }

    public void testSerialization() {
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        WaterfallBarRenderer waterfallBarRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(waterfallBarRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            waterfallBarRenderer2 = (WaterfallBarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        WaterfallBarRendererTests.assertEquals((Object)waterfallBarRenderer, waterfallBarRenderer2);
    }
}

