/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.junit.LineAndShapeRendererTests;

public class LineRenderer3DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LineAndShapeRendererTests.class);
    }

    public LineRenderer3DTests(String string) {
        super(string);
    }

    public void testEquals() {
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        LineRenderer3D lineRenderer3D2 = new LineRenderer3D();
        LineRenderer3DTests.assertEquals((Object)lineRenderer3D, (Object)lineRenderer3D2);
    }

    public void testHashcode() {
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        LineRenderer3D lineRenderer3D2 = new LineRenderer3D();
        LineRenderer3DTests.assertTrue((boolean)lineRenderer3D.equals(lineRenderer3D2));
        int n = lineRenderer3D.hashCode();
        int n2 = lineRenderer3D2.hashCode();
        LineRenderer3DTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        LineRenderer3D lineRenderer3D2 = null;
        try {
            lineRenderer3D2 = (LineRenderer3D)lineRenderer3D.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        LineRenderer3DTests.assertTrue((lineRenderer3D != lineRenderer3D2 ? 1 : 0) != 0);
        LineRenderer3DTests.assertTrue((lineRenderer3D.getClass() == lineRenderer3D2.getClass() ? 1 : 0) != 0);
        LineRenderer3DTests.assertTrue((boolean)lineRenderer3D.equals(lineRenderer3D2));
        LineRenderer3DTests.assertTrue((boolean)this.checkIndependence(lineRenderer3D, lineRenderer3D2));
    }

    private boolean checkIndependence(LineRenderer3D lineRenderer3D, LineRenderer3D lineRenderer3D2) {
        boolean bl = lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D.setShapesVisible(!lineRenderer3D.isShapesVisible());
        boolean bl2 = !lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D2.setShapesVisible(lineRenderer3D.isShapesVisible());
        boolean bl3 = lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D.setLinesVisible(!lineRenderer3D.isLinesVisible());
        boolean bl4 = !lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D2.setLinesVisible(lineRenderer3D.isLinesVisible());
        boolean bl5 = lineRenderer3D.equals(lineRenderer3D2);
        boolean bl6 = true;
        Boolean bl7 = lineRenderer3D.getShapesFilled();
        if (bl7 != null) {
            bl6 = bl7 == false;
        }
        lineRenderer3D.setShapesFilled(bl6);
        boolean bl8 = !lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D2.setShapesFilled(bl6);
        boolean bl9 = lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D.setShapesFilled(false);
        lineRenderer3D2.setShapesFilled(false);
        lineRenderer3D.setSeriesShapesFilled(0, false);
        lineRenderer3D2.setSeriesShapesFilled(0, true);
        boolean bl10 = !lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D2.setSeriesShapesFilled(0, false);
        boolean bl11 = lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D.setDefaultShapesFilled(false);
        lineRenderer3D2.setDefaultShapesFilled(true);
        boolean bl12 = !lineRenderer3D.equals(lineRenderer3D2);
        lineRenderer3D2.setDefaultShapesFilled(false);
        boolean bl13 = lineRenderer3D.equals(lineRenderer3D2);
        return bl && bl2 && bl3 && bl4 && bl5 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13;
    }

    public void testSerialization() {
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        LineRenderer3D lineRenderer3D2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(lineRenderer3D);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            lineRenderer3D2 = (LineRenderer3D)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        LineRenderer3DTests.assertEquals((Object)lineRenderer3D, lineRenderer3D2);
    }
}

