/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.LevelRenderer;

public class LevelRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LevelRendererTests.class);
    }

    public LevelRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        LevelRenderer levelRenderer = new LevelRenderer();
        LevelRenderer levelRenderer2 = new LevelRenderer();
        LevelRendererTests.assertTrue((boolean)levelRenderer.equals(levelRenderer2));
        LevelRendererTests.assertTrue((boolean)levelRenderer2.equals(levelRenderer));
        levelRenderer.setItemMargin(0.123);
        LevelRendererTests.assertFalse((boolean)levelRenderer.equals(levelRenderer2));
        levelRenderer2.setItemMargin(0.123);
        LevelRendererTests.assertTrue((boolean)levelRenderer.equals(levelRenderer2));
        levelRenderer.setMaxItemWidth(0.234);
        LevelRendererTests.assertFalse((boolean)levelRenderer.equals(levelRenderer2));
        levelRenderer2.setMaxItemWidth(0.234);
        LevelRendererTests.assertTrue((boolean)levelRenderer.equals(levelRenderer2));
    }

    public void testHashcode() {
        LevelRenderer levelRenderer = new LevelRenderer();
        LevelRenderer levelRenderer2 = new LevelRenderer();
        LevelRendererTests.assertTrue((boolean)levelRenderer.equals(levelRenderer2));
        int n = levelRenderer.hashCode();
        int n2 = levelRenderer2.hashCode();
        LevelRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        LevelRenderer levelRenderer = new LevelRenderer();
        levelRenderer.setItemMargin(0.123);
        levelRenderer.setMaxItemWidth(0.234);
        LevelRenderer levelRenderer2 = null;
        try {
            levelRenderer2 = (LevelRenderer)levelRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        LevelRendererTests.assertTrue((levelRenderer != levelRenderer2 ? 1 : 0) != 0);
        LevelRendererTests.assertTrue((levelRenderer.getClass() == levelRenderer2.getClass() ? 1 : 0) != 0);
        LevelRendererTests.assertTrue((boolean)levelRenderer.equals(levelRenderer2));
        LevelRendererTests.assertTrue((boolean)this.checkIndependence(levelRenderer, levelRenderer2));
    }

    private boolean checkIndependence(LevelRenderer levelRenderer, LevelRenderer levelRenderer2) {
        boolean bl = levelRenderer.equals(levelRenderer2);
        levelRenderer.setItemMargin(0.0);
        boolean bl2 = !levelRenderer.equals(levelRenderer2);
        levelRenderer2.setItemMargin(0.0);
        boolean bl3 = levelRenderer.equals(levelRenderer2);
        return bl && bl2 && bl3;
    }

    public void testSerialization() {
        LevelRenderer levelRenderer = new LevelRenderer();
        LevelRenderer levelRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(levelRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            levelRenderer2 = (LevelRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LevelRendererTests.assertEquals((Object)levelRenderer, levelRenderer2);
    }
}

