/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.junit.RendererChangeDetector;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;

public class BarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BarRendererTests.class);
    }

    public BarRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        BarRenderer barRenderer = new BarRenderer();
        BarRenderer barRenderer2 = new BarRenderer();
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        BarRendererTests.assertTrue((boolean)barRenderer2.equals(barRenderer));
        barRenderer.setBase(0.123);
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setBase(0.123);
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setItemMargin(0.22);
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setItemMargin(0.22);
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setDrawBarOutline(!barRenderer.isDrawBarOutline());
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setDrawBarOutline(!barRenderer2.isDrawBarOutline());
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setMaxBarWidth(0.11);
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setMaxBarWidth(0.11);
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setMinimumBarLength(0.04);
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setMinimumBarLength(0.04);
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        barRenderer.setNegativeItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        BarRendererTests.assertFalse((boolean)barRenderer.equals(barRenderer2));
        barRenderer2.setNegativeItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE1, TextAnchor.CENTER));
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
    }

    public void testHashcode() {
        BarRenderer barRenderer = new BarRenderer();
        BarRenderer barRenderer2 = new BarRenderer();
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
        int n = barRenderer.hashCode();
        int n2 = barRenderer2.hashCode();
        BarRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        BarRenderer barRenderer2 = null;
        try {
            barRenderer2 = (BarRenderer)barRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        BarRendererTests.assertTrue((barRenderer != barRenderer2 ? 1 : 0) != 0);
        BarRendererTests.assertTrue((barRenderer.getClass() == barRenderer2.getClass() ? 1 : 0) != 0);
        BarRendererTests.assertTrue((boolean)barRenderer.equals(barRenderer2));
    }

    public void testSerialization() {
        BarRenderer barRenderer = new BarRenderer();
        BarRenderer barRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(barRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            barRenderer2 = (BarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        BarRendererTests.assertEquals((Object)barRenderer, barRenderer2);
    }

    public void testEventNotification() {
        RendererChangeDetector rendererChangeDetector = new RendererChangeDetector();
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.addChangeListener(rendererChangeDetector);
        rendererChangeDetector.setNotified(false);
        barRenderer.setPaint(Color.red);
        BarRendererTests.assertTrue((boolean)rendererChangeDetector.getNotified());
    }
}

