/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class StatisticalLineAndShapeRenderer
extends LineAndShapeRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3557517173697777579L;

    public StatisticalLineAndShapeRenderer() {
        this(true, true);
    }

    public StatisticalLineAndShapeRenderer(boolean bl, boolean bl2) {
        super(true, true);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Serializable serializable;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        Number number2 = statisticalCategoryDataset.getMeanValue(n, n2);
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        Shape shape = this.getItemShape(n, n2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            shape = ShapeUtilities.createTranslatedShape(shape, d2, d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            shape = ShapeUtilities.createTranslatedShape(shape, d, d2);
        }
        if (this.isShapesVisible()) {
            if (this.getItemShapeFilled(n, n2)) {
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.fill(shape);
            } else {
                if (this.getUseOutlinePaint()) {
                    graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.draw(shape);
            }
        }
        if (this.isLinesVisible() && n2 != 0 && (serializable = statisticalCategoryDataset.getValue(n, n2 - 1)) != null) {
            double d3 = ((Number)serializable).doubleValue();
            double d4 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d5, d4, d2, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d4, d5, d, d2);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.draw(double_);
        }
        serializable = categoryPlot.getRangeAxisEdge();
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        double d6 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
        d6 += (double)n * categoryItemRendererState.getBarWidth();
        graphics2D.setPaint(this.getItemPaint(n, n2));
        double d7 = statisticalCategoryDataset.getStdDevValue(n, n2).doubleValue();
        double d8 = number2.doubleValue() + d7 > valueAxis.getRange().getUpperBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getUpperBound(), rectangle2D, (RectangleEdge)serializable) : valueAxis.valueToJava2D(number2.doubleValue() + d7, rectangle2D, (RectangleEdge)serializable);
        double d9 = number2.doubleValue() + d7 < valueAxis.getRange().getLowerBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getLowerBound(), rectangle2D, (RectangleEdge)serializable) : valueAxis.valueToJava2D(number2.doubleValue() - d7, rectangle2D, (RectangleEdge)serializable);
        Line2D.Double double_ = null;
        double_ = new Line2D.Double(d, d9, d, d8);
        graphics2D.draw(double_);
        double_ = new Line2D.Double(d - 5.0, d8, d + 5.0, d8);
        graphics2D.draw(double_);
        double_ = new Line2D.Double(d - 5.0, d9, d + 5.0, d9);
        graphics2D.draw(double_);
        if (this.isItemLabelVisible(n, n2)) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d2, d, number2.doubleValue() < 0.0);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d2, number2.doubleValue() < 0.0);
            }
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }
}

